/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class SolarisFileStore
extends UnixFileStore {
    private final boolean xattrEnabled = this.xattrEnabled();

    SolarisFileStore(UnixPath unixPath) throws IOException {
        super(unixPath);
    }

    SolarisFileStore(UnixFileSystem unixFileSystem, UnixMountEntry unixMountEntry) throws IOException {
        super(unixFileSystem, unixMountEntry);
    }

    private boolean xattrEnabled() {
        long l = 0L;
        try {
            l = UnixNativeDispatcher.pathconf(this.file(), 100);
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        return l != 0L;
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        for (UnixMountEntry unixMountEntry : this.file().getFileSystem().getMountEntries()) {
            if (unixMountEntry.dev() != this.dev()) continue;
            return unixMountEntry;
        }
        throw new IOException("Device not found in mnttab");
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        if (clazz == AclFileAttributeView.class) {
            UnixFileStore.FeatureStatus featureStatus = this.checkIfFeaturePresent("nfsv4acl");
            switch (featureStatus) {
                case PRESENT: {
                    return true;
                }
                case NOT_PRESENT: {
                    return false;
                }
            }
            return this.type().equals("zfs");
        }
        if (clazz == UserDefinedFileAttributeView.class) {
            UnixFileStore.FeatureStatus featureStatus = this.checkIfFeaturePresent("xattr");
            switch (featureStatus) {
                case PRESENT: {
                    return true;
                }
                case NOT_PRESENT: {
                    return false;
                }
            }
            return this.xattrEnabled;
        }
        return super.supportsFileAttributeView(clazz);
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        if (string.equals("acl")) {
            return this.supportsFileAttributeView(AclFileAttributeView.class);
        }
        if (string.equals("user")) {
            return this.supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        return super.supportsFileAttributeView(string);
    }
}

