/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.dcmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import jdk.test.lib.dcmd.CommandExecutor;
import jdk.test.lib.dcmd.CommandExecutorException;
import jdk.test.lib.process.OutputAnalyzer;

public class JMXExecutor
extends CommandExecutor {
    private final MBeanServerConnection mbs;

    public JMXExecutor() {
        this.mbs = ManagementFactory.getPlatformMBeanServer();
    }

    public JMXExecutor(String target) {
        String urlStr;
        if (target.matches("^\\w[\\w\\-]*(\\.[\\w\\-]+)*:\\d+$")) {
            urlStr = String.format("service:jmx:rmi:///jndi/rmi://%s/jmxrmi", target);
        } else if (target.startsWith("service:")) {
            urlStr = target;
        } else {
            throw new IllegalArgumentException("Could not recognize target string: " + target);
        }
        try {
            JMXServiceURL url = new JMXServiceURL(urlStr);
            JMXConnector c = JMXConnectorFactory.connect(url, new HashMap());
            this.mbs = c.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new CommandExecutorException("Could not initiate connection to target: " + target, e);
        }
    }

    @Override
    protected OutputAnalyzer executeImpl(String cmd) throws CommandExecutorException {
        String stdout = "";
        String stderr = "";
        String[] cmdParts = cmd.split(" ", 2);
        String operation = JMXExecutor.commandToMethodName(cmdParts[0]);
        Object[] dcmdArgs = this.produceArguments(cmdParts);
        String[] signature = new String[]{String[].class.getName()};
        ObjectName beanName = this.getMBeanName();
        try {
            stdout = (String)this.mbs.invoke(beanName, operation, dcmdArgs, signature);
        }
        catch (ReflectionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchMethodException) {
                String message = "Unknown diagnostic command: " + operation;
                stderr = JMXExecutor.exceptionTraceAsString(new IllegalArgumentException(message, e));
            } else {
                this.rethrowExecutorException(operation, dcmdArgs, e);
            }
        }
        catch (IOException | InstanceNotFoundException e) {
            this.rethrowExecutorException(operation, dcmdArgs, e);
        }
        catch (MBeanException e) {
            stdout = JMXExecutor.exceptionTraceAsString(e);
        }
        return new OutputAnalyzer(stdout, stderr);
    }

    private void rethrowExecutorException(String operation, Object[] dcmdArgs, Exception e) throws CommandExecutorException {
        String message = String.format("Could not invoke: %s %s", operation, String.join((CharSequence)" ", (String[])dcmdArgs[0]));
        throw new CommandExecutorException(message, e);
    }

    private ObjectName getMBeanName() throws CommandExecutorException {
        String MBeanName = "com.sun.management:type=DiagnosticCommand";
        try {
            return new ObjectName(MBeanName);
        }
        catch (MalformedObjectNameException e) {
            String message = "MBean not found: " + MBeanName;
            throw new CommandExecutorException(message, e);
        }
    }

    private Object[] produceArguments(String[] cmdParts) {
        Object[] dcmdArgs = new Object[]{new String[0]};
        if (cmdParts.length == 2) {
            dcmdArgs[0] = cmdParts[1].split(" ");
        }
        return dcmdArgs;
    }

    private static String commandToMethodName(String cmd) {
        String operation = "";
        boolean up = false;
        for (char c : cmd.toCharArray()) {
            if ('.' == c || '_' == c) {
                up = true;
                continue;
            }
            if (up) {
                operation = operation.concat(Character.toString(c).toUpperCase());
                up = false;
                continue;
            }
            operation = operation.concat(Character.toString(c).toLowerCase());
        }
        return operation;
    }

    private static String exceptionTraceAsString(Throwable cause) {
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

