/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.containers.cgroup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import jdk.internal.platform.CgroupV1Metrics;
import jdk.internal.platform.Metrics;
import jdk.test.lib.Asserts;
import jdk.test.lib.containers.cgroup.CgroupMetricsTester;

public class MetricsTesterCgroupV1
implements CgroupMetricsTester {
    private static final long RETVAL_UNAVAILABLE = -1L;
    private static long unlimited_minimum = 0x7FFFFFFFFF000000L;
    long startSysVal;
    long startUserVal;
    long startUsage;
    long[] startPerCpu;
    private static final Set<String> allowedSubSystems = Stream.of(Controller.values()).map(Controller::value).collect(Collectors.toSet());
    private static final Map<String, String[]> subSystemPaths = new HashMap<String, String[]>();

    private static void setPath(String[] line) {
        String[] subSystems;
        String cgroupPath = line[2];
        for (String subSystem : subSystems = line[1].split(",")) {
            if (!allowedSubSystems.contains(subSystem)) continue;
            String[] paths = subSystemPaths.get(subSystem);
            Object finalPath = "";
            String root = paths[0];
            String mountPoint = paths[1];
            if (root != null && cgroupPath != null) {
                if (root.equals("/")) {
                    finalPath = !cgroupPath.equals("/") ? mountPoint + cgroupPath : mountPoint;
                } else if (root.equals(cgroupPath)) {
                    finalPath = mountPoint;
                } else if (cgroupPath.startsWith(root) && cgroupPath.length() > root.length()) {
                    String cgroupSubstr = cgroupPath.substring(root.length());
                    finalPath = mountPoint + cgroupSubstr;
                }
            }
            subSystemPaths.put(subSystem, new String[]{finalPath, mountPoint});
        }
    }

    private static void createSubsystems(String[] line) {
        if (line.length < 5) {
            return;
        }
        Path p = Paths.get(line[4], new String[0]);
        String subsystemName = p.getFileName().toString();
        if (subsystemName != null) {
            for (String subSystem : subsystemName.split(",")) {
                if (!allowedSubSystems.contains(subSystem)) continue;
                subSystemPaths.put(subSystem, new String[]{line[3], line[4]});
            }
        }
    }

    public void setup() {
        Metrics metrics = Metrics.systemMetrics();
        this.startSysVal = metrics.getCpuSystemUsage();
        this.startUserVal = metrics.getCpuUserUsage();
        this.startUsage = metrics.getCpuUsage();
        this.startPerCpu = metrics.getPerCpuUsage();
        try {
            Stream<String> lines = Files.lines(Paths.get("/proc/self/mountinfo", new String[0]));
            lines.filter(line -> line.contains(" - cgroup cgroup ")).map(line -> line.split(" ")).forEach(MetricsTesterCgroupV1::createSubsystems);
            lines.close();
            lines = Files.lines(Paths.get("/proc/self/cgroup", new String[0]));
            lines.map(line -> line.split(":")).filter(line -> ((String[])line).length >= 3).forEach(MetricsTesterCgroupV1::setPath);
            lines.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getFileContents(Controller subSystem, String fileName) {
        String fname = subSystemPaths.get(subSystem.value())[0] + File.separator + fileName;
        try {
            return new Scanner(new File(fname)).useDelimiter("\\Z").next();
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to open : " + fname);
            return null;
        }
    }

    private static long getLongValueFromFile(Controller subSystem, String fileName) {
        String data = MetricsTesterCgroupV1.getFileContents(subSystem, fileName);
        return data == null || data.isEmpty() ? -1L : MetricsTesterCgroupV1.convertStringToLong(data);
    }

    private static long convertStringToLong(String strval) {
        return CgroupMetricsTester.convertStringToLong(strval, -1L, Long.MAX_VALUE);
    }

    private static long getLongValueFromFile(Controller subSystem, String metric, String subMetric) {
        String stats = MetricsTesterCgroupV1.getFileContents(subSystem, metric);
        String[] tokens = stats.split("[\\r\\n]+");
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].startsWith(subMetric)) continue;
            String strval = tokens[i].split("\\s+")[1];
            return MetricsTesterCgroupV1.convertStringToLong(strval);
        }
        return -1L;
    }

    private static double getDoubleValueFromFile(Controller subSystem, String fileName) {
        String data = MetricsTesterCgroupV1.getFileContents(subSystem, fileName);
        return data == null || data.isEmpty() ? -1.0 : Double.parseDouble(data);
    }

    private static void fail(Controller system, String metric, long oldVal, long testVal) {
        CgroupMetricsTester.fail(system.value, metric, oldVal, testVal);
    }

    private static void fail(Controller system, String metric, String oldVal, String testVal) {
        CgroupMetricsTester.fail(system.value, metric, oldVal, testVal);
    }

    private static void fail(Controller system, String metric, double oldVal, double testVal) {
        CgroupMetricsTester.fail(system.value, metric, oldVal, testVal);
    }

    private static void fail(Controller system, String metric, boolean oldVal, boolean testVal) {
        CgroupMetricsTester.fail(system.value, metric, oldVal, testVal);
    }

    private static void warn(Controller system, String metric, long oldVal, long testVal) {
        CgroupMetricsTester.warn(system.value, metric, oldVal, testVal);
    }

    private Long[] boxedArrayOrNull(long[] primitiveArray) {
        if (primitiveArray == null) {
            return null;
        }
        return (Long[])LongStream.of(primitiveArray).boxed().toArray(Long[]::new);
    }

    @Override
    public void testMemorySubsystem() {
        boolean newOomKillEnabled;
        long newVal;
        CgroupV1Metrics metrics = (CgroupV1Metrics)Metrics.systemMetrics();
        long oldVal = metrics.getMemoryFailCount();
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.failcnt"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.failcnt", oldVal, newVal);
        }
        oldVal = metrics.getMemoryLimit();
        newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.limit_in_bytes");
        long l = newVal = newVal > unlimited_minimum ? -1L : newVal;
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.limit_in_bytes", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getMemoryMaxUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.max_usage_in_bytes"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.max_usage_in_bytes", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getMemoryUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.usage_in_bytes"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.usage_in_bytes", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getKernelMemoryFailCount(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.kmem.failcnt"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.kmem.failcnt", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getKernelMemoryMaxUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.kmem.max_usage_in_bytes"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.kmem.max_usage_in_bytes", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getKernelMemoryUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.kmem.usage_in_bytes"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.kmem.usage_in_bytes", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getTcpMemoryFailCount(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.kmem.tcp.failcnt"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.kmem.tcp.failcnt", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getTcpMemoryMaxUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.kmem.tcp.max_usage_in_bytes"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.kmem.tcp.max_usage_in_bytes", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getTcpMemoryUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.kmem.tcp.usage_in_bytes"))) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.kmem.tcp.usage_in_bytes", oldVal, newVal);
        }
        if (metrics.getMemoryAndSwapLimit() > metrics.getMemoryLimit()) {
            oldVal = metrics.getMemoryAndSwapFailCount();
            if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.memsw.failcnt"))) {
                MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.memsw.failcnt", oldVal, newVal);
            }
            oldVal = metrics.getMemoryAndSwapLimit();
            newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.memsw.limit_in_bytes");
            long l2 = newVal = newVal > unlimited_minimum ? -1L : newVal;
            if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
                MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.memsw.limit_in_bytes", oldVal, newVal);
            }
            if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getMemoryAndSwapMaxUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.memsw.max_usage_in_bytes"))) {
                MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.memsw.max_usage_in_bytes", oldVal, newVal);
            }
            if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getMemoryAndSwapUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.memsw.usage_in_bytes"))) {
                MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.memsw.usage_in_bytes", oldVal, newVal);
            }
        }
        oldVal = metrics.getMemorySoftLimit();
        newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.soft_limit_in_bytes");
        long l3 = newVal = newVal > unlimited_minimum ? -1L : newVal;
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "memory.soft_limit_in_bytes", oldVal, newVal);
        }
        boolean oomKillEnabled = metrics.isMemoryOOMKillEnabled();
        boolean bl = newOomKillEnabled = MetricsTesterCgroupV1.getLongValueFromFile(Controller.MEMORY, "memory.oom_control", "oom_kill_disable") == 0L;
        if (oomKillEnabled != newOomKillEnabled) {
            throw new RuntimeException("Test failed for - " + Controller.MEMORY.value + ":memory.oom_control:oom_kill_disable, expected [" + oomKillEnabled + "], got [" + newOomKillEnabled + "]");
        }
    }

    @Override
    public void testCpuAccounting() {
        Long[] oldVals;
        long newVal;
        CgroupV1Metrics metrics = (CgroupV1Metrics)Metrics.systemMetrics();
        long oldVal = metrics.getCpuUsage();
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpuacct.usage"))) {
            MetricsTesterCgroupV1.warn(Controller.CPUACCT, "cpuacct.usage", oldVal, newVal);
        }
        String newValsStr = MetricsTesterCgroupV1.getFileContents(Controller.CPUACCT, "cpuacct.usage_percpu");
        Long[] newVals = null;
        if (newValsStr != null) {
            newVals = (Long[])Stream.of(newValsStr.split("\\s+")).map(Long::parseLong).toArray(Long[]::new);
        }
        if ((oldVals = this.boxedArrayOrNull(metrics.getPerCpuUsage())) != null) {
            for (int i = 0; i < oldVals.length; ++i) {
                if (CgroupMetricsTester.compareWithErrorMargin(oldVals[i], newVals[i])) continue;
                MetricsTesterCgroupV1.warn(Controller.CPUACCT, "cpuacct.usage_percpu", (long)oldVals[i], (long)newVals[i]);
            }
        } else {
            Asserts.assertNull(newVals, Controller.CPUACCT.value() + "cpuacct.usage_percpu not both null");
        }
        oldVal = metrics.getCpuUserUsage();
        newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpuacct.stat", "user");
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
            MetricsTesterCgroupV1.warn(Controller.CPUACCT, "cpuacct.usage - user", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuSystemUsage(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpuacct.stat", "system"))) {
            MetricsTesterCgroupV1.warn(Controller.CPUACCT, "cpuacct.usage - system", oldVal, newVal);
        }
    }

    @Override
    public void testCpuSchedulingMetrics() {
        long newVal;
        CgroupV1Metrics metrics = (CgroupV1Metrics)Metrics.systemMetrics();
        long oldVal = metrics.getCpuPeriod();
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpu.cfs_period_us"))) {
            MetricsTesterCgroupV1.fail(Controller.CPUACCT, "cpu.cfs_period_us", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuQuota(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpu.cfs_quota_us"))) {
            MetricsTesterCgroupV1.fail(Controller.CPUACCT, "cpu.cfs_quota_us", oldVal, newVal);
        }
        oldVal = metrics.getCpuShares();
        newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpu.shares");
        if (newVal == 0L || newVal == 1024L) {
            newVal = -1L;
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
            MetricsTesterCgroupV1.fail(Controller.CPUACCT, "cpu.shares", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuNumPeriods(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpu.stat", "nr_periods"))) {
            MetricsTesterCgroupV1.fail(Controller.CPUACCT, "cpu.stat - nr_periods", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuNumThrottled(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpu.stat", "nr_throttled"))) {
            MetricsTesterCgroupV1.fail(Controller.CPUACCT, "cpu.stat - nr_throttled", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuThrottledTime(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUACCT, "cpu.stat", "throttled_time"))) {
            MetricsTesterCgroupV1.fail(Controller.CPUACCT, "cpu.stat - throttled_time", oldVal, newVal);
        }
    }

    @Override
    public void testCpuSets() {
        boolean newV;
        double newValue;
        double oldValue;
        CgroupV1Metrics metrics = (CgroupV1Metrics)Metrics.systemMetrics();
        Object[] oldVal = CgroupMetricsTester.boxedArrayOrNull(metrics.getCpuSetCpus());
        oldVal = CgroupMetricsTester.sortAllowNull((Integer[])oldVal);
        String cpusstr = MetricsTesterCgroupV1.getFileContents(Controller.CPUSET, "cpuset.cpus");
        Object[] newVal = CgroupMetricsTester.convertCpuSetsToArray(cpusstr);
        if (Arrays.compare((Comparable[])oldVal, (Comparable[])(newVal = CgroupMetricsTester.sortAllowNull((Integer[])newVal))) != 0) {
            MetricsTesterCgroupV1.fail(Controller.CPUSET, "cpuset.cpus", Arrays.toString(oldVal), Arrays.toString(newVal));
        }
        int[] cpuSets = metrics.getEffectiveCpuSetCpus();
        oldVal = CgroupMetricsTester.boxedArrayOrNull(cpuSets);
        oldVal = CgroupMetricsTester.sortAllowNull((Integer[])oldVal);
        cpusstr = MetricsTesterCgroupV1.getFileContents(Controller.CPUSET, "cpuset.effective_cpus");
        newVal = CgroupMetricsTester.convertCpuSetsToArray(cpusstr);
        if (Arrays.compare((Comparable[])oldVal, (Comparable[])(newVal = CgroupMetricsTester.sortAllowNull((Integer[])newVal))) != 0) {
            MetricsTesterCgroupV1.fail(Controller.CPUSET, "cpuset.effective_cpus", Arrays.toString(oldVal), Arrays.toString(newVal));
        }
        oldVal = CgroupMetricsTester.boxedArrayOrNull(metrics.getCpuSetMems());
        oldVal = CgroupMetricsTester.sortAllowNull((Integer[])oldVal);
        cpusstr = MetricsTesterCgroupV1.getFileContents(Controller.CPUSET, "cpuset.mems");
        newVal = CgroupMetricsTester.convertCpuSetsToArray(cpusstr);
        if (Arrays.compare((Comparable[])oldVal, (Comparable[])(newVal = CgroupMetricsTester.sortAllowNull((Integer[])newVal))) != 0) {
            MetricsTesterCgroupV1.fail(Controller.CPUSET, "cpuset.mems", Arrays.toString(oldVal), Arrays.toString(newVal));
        }
        int[] cpuSetMems = metrics.getEffectiveCpuSetMems();
        oldVal = CgroupMetricsTester.boxedArrayOrNull(cpuSetMems);
        oldVal = CgroupMetricsTester.sortAllowNull((Integer[])oldVal);
        cpusstr = MetricsTesterCgroupV1.getFileContents(Controller.CPUSET, "cpuset.effective_mems");
        newVal = CgroupMetricsTester.convertCpuSetsToArray(cpusstr);
        if (Arrays.compare((Comparable[])oldVal, (Comparable[])(newVal = CgroupMetricsTester.sortAllowNull((Integer[])newVal))) != 0) {
            MetricsTesterCgroupV1.fail(Controller.CPUSET, "cpuset.effective_mems", Arrays.toString(oldVal), Arrays.toString(newVal));
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldValue = metrics.getCpuSetMemoryPressure(), newValue = MetricsTesterCgroupV1.getDoubleValueFromFile(Controller.CPUSET, "cpuset.memory_pressure"))) {
            MetricsTesterCgroupV1.fail(Controller.CPUSET, "cpuset.memory_pressure", oldValue, newValue);
        }
        boolean oldV = metrics.isCpuSetMemoryPressureEnabled();
        boolean bl = newV = MetricsTesterCgroupV1.getLongValueFromFile(Controller.CPUSET, "cpuset.memory_pressure_enabled") == 1L;
        if (oldV != newV) {
            MetricsTesterCgroupV1.fail(Controller.CPUSET, "cpuset.memory_pressure_enabled", oldV, newV);
        }
    }

    private void testBlkIO() {
        long newVal;
        CgroupV1Metrics metrics = (CgroupV1Metrics)Metrics.systemMetrics();
        long oldVal = metrics.getBlkIOServiceCount();
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.BLKIO, "blkio.throttle.io_service_bytes", "Total"))) {
            MetricsTesterCgroupV1.fail(Controller.BLKIO, "blkio.throttle.io_service_bytes - Total", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getBlkIOServiced(), newVal = MetricsTesterCgroupV1.getLongValueFromFile(Controller.BLKIO, "blkio.throttle.io_serviced", "Total"))) {
            MetricsTesterCgroupV1.fail(Controller.BLKIO, "blkio.throttle.io_serviced - Total", oldVal, newVal);
        }
    }

    @Override
    public void testCpuConsumption() throws IOException, InterruptedException {
        CgroupV1Metrics metrics = (CgroupV1Metrics)Metrics.systemMetrics();
        long newSysVal = metrics.getCpuSystemUsage();
        long newUserVal = metrics.getCpuUserUsage();
        long newUsage = metrics.getCpuUsage();
        long[] newPerCpu = metrics.getPerCpuUsage();
        if (newSysVal < this.startSysVal) {
            MetricsTesterCgroupV1.fail(Controller.CPU, "getCpuSystemUsage", newSysVal, this.startSysVal);
        }
        if (newUserVal < this.startUserVal) {
            MetricsTesterCgroupV1.fail(Controller.CPU, "getCpuUserUsage", newUserVal, this.startUserVal);
        }
        if (newUsage <= this.startUsage) {
            MetricsTesterCgroupV1.fail(Controller.CPU, "getCpuUsage", newUsage, this.startUsage);
        }
        if (this.startPerCpu != null) {
            boolean success = false;
            for (int i = 0; i < this.startPerCpu.length; ++i) {
                if (newPerCpu[i] <= this.startPerCpu[i]) continue;
                success = true;
                break;
            }
            if (!success) {
                MetricsTesterCgroupV1.fail(Controller.CPU, "getPerCpuUsage", Arrays.toString(newPerCpu), Arrays.toString(this.startPerCpu));
            }
        } else {
            Asserts.assertNull(newPerCpu, Controller.CPU.value() + " getPerCpuUsage not both null");
        }
    }

    @Override
    public void testMemoryUsage() throws Exception {
        CgroupV1Metrics metrics = (CgroupV1Metrics)Metrics.systemMetrics();
        long memoryMaxUsage = metrics.getMemoryMaxUsage();
        long memoryUsage = metrics.getMemoryUsage();
        long newMemoryMaxUsage = 0L;
        long newMemoryUsage = 0L;
        byte[][] bytes = new byte[32][];
        for (int i = 0; i < 32; ++i) {
            bytes[i] = new byte[0x800000];
            newMemoryUsage = metrics.getMemoryUsage();
            if (newMemoryUsage > memoryUsage) break;
        }
        if ((newMemoryMaxUsage = metrics.getMemoryMaxUsage()) < memoryMaxUsage) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "getMemoryMaxUsage", memoryMaxUsage, newMemoryMaxUsage);
        }
        if (newMemoryUsage < memoryUsage) {
            MetricsTesterCgroupV1.fail(Controller.MEMORY, "getMemoryUsage", memoryUsage, newMemoryUsage);
        }
    }

    @Override
    public void testMisc() {
        this.testBlkIO();
    }

    static enum Controller {
        MEMORY("memory"),
        CPUSET("cpuset"),
        CPU("cpu"),
        CPUACCT("cpuacct"),
        BLKIO("blkio");

        private String value;

        private Controller(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

