/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassLoadUtils {
    private ClassLoadUtils() {
    }

    public static String getClassPath(String className) {
        int i;
        String fileName = className.replace(".", File.separator) + ".class";
        String[] classPath = System.getProperty("java.class.path").split(File.pathSeparator);
        File target = null;
        for (i = 0; i < classPath.length; ++i) {
            target = new File(classPath[i] + File.separator + fileName);
            System.out.println("Try: " + String.valueOf(target));
            if (target.exists()) break;
        }
        if (i != classPath.length) {
            return classPath[i];
        }
        return null;
    }

    public static String getClassPathFileName(String className) {
        int i;
        String fileName = className.replace(".", File.separator) + ".class";
        String[] classPath = System.getProperty("java.class.path").split(File.pathSeparator);
        File target = null;
        for (i = 0; i < classPath.length; ++i) {
            target = new File(classPath[i] + File.separator + fileName);
            System.out.println("Try: " + String.valueOf(target));
            if (target.exists()) break;
        }
        if (i != classPath.length) {
            try {
                return target.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static String getRedefineClassFileName(String dir, String className) {
        String fileName = ClassLoadUtils.getClassPathFileName(className);
        if (fileName == null) {
            return null;
        }
        if (fileName.contains("classes")) {
            return fileName.replace("classes", dir);
        }
        String classPath = ClassLoadUtils.getClassPath(className);
        if (classPath != null) {
            return classPath + File.separator + "newclass" + File.separator + className.replace(".", File.separator) + ".class";
        }
        return null;
    }

    public static String getRedefineClassFileName(String className) {
        return ClassLoadUtils.getRedefineClassFileName("newclass", className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        long countl = file.length();
        if (countl > Integer.MAX_VALUE) {
            throw new IOException("File is too huge");
        }
        int count = (int)countl;
        byte[] buffer = new byte[count];
        try {
            int k;
            for (int n = 0; n < count; n += k) {
                k = ((InputStream)in).read(buffer, n, count - n);
                if (k >= 0) continue;
                throw new IOException("Unexpected EOF");
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return buffer;
    }

    public static byte[] readFile(String name) throws IOException {
        return ClassLoadUtils.readFile(new File(name));
    }
}

