/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.artifacts;

import java.nio.file.Path;
import java.nio.file.Paths;
import jdk.test.lib.artifacts.Artifact;
import jdk.test.lib.artifacts.ArtifactManager;
import jdk.test.lib.artifacts.ArtifactResolverException;

public class DefaultArtifactManager
implements ArtifactManager {
    @Override
    public Path resolve(Artifact artifact) throws ArtifactResolverException {
        return this.resolve(artifact.name());
    }

    public Path resolve(String name) throws ArtifactResolverException {
        String location = System.getProperty(DefaultArtifactManager.artifactProperty(name));
        if (location == null) {
            throw new ArtifactResolverException("Couldn't automatically resolve dependency for " + name + "\nPlease specify the location using " + DefaultArtifactManager.artifactProperty(name));
        }
        return Paths.get(location, new String[0]);
    }

    private static String artifactProperty(String name) {
        return "jdk.test.lib.artifacts." + name;
    }
}

