/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedObject;
import jdk.test.lib.Asserts;

public final class EventField {
    public final RecordedObject event;
    public final ValueDescriptor desc;

    public EventField(RecordedObject event, ValueDescriptor valueDescriptor) {
        this.event = event;
        this.desc = valueDescriptor;
    }

    public <T extends Comparable<T>> boolean isEqual(T value) {
        return value == (Comparable)this.getValue();
    }

    public <T extends Comparable<T>> EventField equal(T value) {
        this.doAssert(() -> Asserts.assertEquals((Comparable)this.getValue(), value, this.getErrMsg("Value not equal to " + String.valueOf(value))));
        return this;
    }

    public <T extends Comparable<T>> EventField notEqual(T value) {
        this.doAssert(() -> Asserts.assertNotEquals((Comparable)this.getValue(), value, this.getErrMsg("Value equal to " + String.valueOf(value))));
        return this;
    }

    public <T extends Comparable<T>> EventField above(T value) {
        this.doAssert(() -> Asserts.assertGreaterThan((Comparable)this.getValue(), value, this.getErrMsg("Value not above " + String.valueOf(value))));
        return this;
    }

    public <T extends Comparable<T>> EventField below(T value) {
        this.doAssert(() -> Asserts.assertLessThan((Comparable)this.getValue(), value, this.getErrMsg("Value not below " + String.valueOf(value))));
        return this;
    }

    public <T extends Comparable<T>> EventField atLeast(T value) {
        this.doAssert(() -> Asserts.assertGreaterThanOrEqual((Comparable)this.getValue(), value, this.getErrMsg("Value not atLeast" + String.valueOf(value))));
        return this;
    }

    public <T extends Comparable<T>> EventField atMost(T value) {
        this.doAssert(() -> Asserts.assertLessThanOrEqual((Comparable)this.getValue(), value, this.getErrMsg("Value not atMost " + String.valueOf(value))));
        return this;
    }

    public <T extends Comparable<T>> EventField instring(String part) {
        String value = (String)this.getValue();
        this.doAssert(() -> Asserts.assertTrue(value.contains(part), this.getErrMsg("Value does not contain '" + part + "'")));
        return this;
    }

    public <T> T getValue() {
        return this.event.getValue(this.desc.getName());
    }

    public EventField notNull() {
        this.doAssert(() -> Asserts.assertNotNull(this.getValue(), this.getErrMsg("Field is null")));
        return this;
    }

    public EventField isNull() {
        this.doAssert(() -> Asserts.assertNull(this.getValue(), this.getErrMsg("Field is not null")));
        return this;
    }

    public EventField notEmpty() {
        this.notNull();
        String s = (String)this.getValue();
        this.doAssert(() -> Asserts.assertFalse(s.isEmpty(), this.getErrMsg("Field is empty")));
        return this;
    }

    private void doAssert(AssertFunction f) {
        try {
            f.doAssert();
        }
        catch (RuntimeException e) {
            System.out.printf("Error: %s%nFailed event:%n%s%n", e.getMessage(), this.event.toString());
            throw e;
        }
    }

    public EventField containsAny(String ... allowed) {
        String value = (String)this.getValue();
        List<String> allowedValues = Arrays.asList(allowed);
        boolean contains = false;
        for (String allowedValue : allowed) {
            if (!value.contains(allowedValue)) continue;
            contains = true;
        }
        if (!contains) {
            this.doAssert(() -> Asserts.fail(this.getErrMsg(String.format("Value not in (%s)", allowedValues.stream().collect(Collectors.joining(", "))))));
        }
        return this;
    }

    private String getErrMsg(String msg) {
        String name = this.desc.getName();
        Object value = this.event.getValue(name);
        return String.format("%s, field='%s', value='%s'", msg, name, value);
    }

    @FunctionalInterface
    public static interface AssertFunction {
        public void doAssert();
    }
}

