/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.math.BigInteger;
import java.security.spec.EdECPoint;
import java.util.HexFormat;

public class Convert {
    public static byte[] byteToByteArray(byte v, int length) {
        byte[] result = new byte[length];
        result[0] = v;
        return result;
    }

    public static BigInteger hexStringToBigInteger(boolean clearHighBit, String str) {
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < str.length() / 2; ++i) {
            int curVal = Character.digit(str.charAt(2 * i), 16);
            curVal <<= 4;
            curVal += Character.digit(str.charAt(2 * i + 1), 16);
            if (clearHighBit && i == str.length() / 2 - 1) {
                curVal &= 0x7F;
            }
            result = result.add(BigInteger.valueOf(curVal).shiftLeft(8 * i));
        }
        return result;
    }

    private static EdECPoint byteArrayToEdPoint(byte[] arr) {
        byte msb = arr[arr.length - 1];
        boolean xOdd = (msb & 0x80) != 0;
        int n = arr.length - 1;
        arr[n] = (byte)(arr[n] & 0x7F);
        Convert.reverse(arr);
        BigInteger y = new BigInteger(1, arr);
        return new EdECPoint(xOdd, y);
    }

    public static EdECPoint hexStringToEdPoint(String str) {
        return Convert.byteArrayToEdPoint(HexFormat.of().parseHex(str));
    }

    private static void swap(byte[] arr, int i, int j) {
        byte tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    private static void reverse(byte[] arr) {
        int i = 0;
        for (int j = arr.length - 1; i < j; ++i, --j) {
            Convert.swap(arr, i, j);
        }
    }
}

