/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.util;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.attribute.ModuleAttribute;
import java.lang.classfile.attribute.ModuleExportInfo;
import java.lang.classfile.attribute.ModuleMainClassAttribute;
import java.lang.classfile.attribute.ModuleOpenInfo;
import java.lang.classfile.attribute.ModulePackagesAttribute;
import java.lang.classfile.attribute.ModuleRequireInfo;
import java.lang.classfile.attribute.ModuleResolutionAttribute;
import java.lang.classfile.attribute.ModuleTargetAttribute;
import java.lang.classfile.constantpool.ConstantPoolBuilder;
import java.lang.classfile.constantpool.ModuleEntry;
import java.lang.classfile.constantpool.PackageEntry;
import java.lang.classfile.constantpool.Utf8Entry;
import java.lang.constant.ClassDesc;
import java.lang.constant.PackageDesc;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.AccessFlag;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import jdk.internal.module.ModuleResolution;
import jdk.internal.module.ModuleTarget;

public final class ModuleInfoWriter {
    private static final Map<ModuleDescriptor.Modifier, Integer> MODULE_MODS_TO_FLAGS = Map.of(ModuleDescriptor.Modifier.OPEN, 32, ModuleDescriptor.Modifier.SYNTHETIC, 4096, ModuleDescriptor.Modifier.MANDATED, 32768);
    private static final Map<ModuleDescriptor.Requires.Modifier, Integer> REQUIRES_MODS_TO_FLAGS = Map.of(ModuleDescriptor.Requires.Modifier.TRANSITIVE, 32, ModuleDescriptor.Requires.Modifier.STATIC, 64, ModuleDescriptor.Requires.Modifier.SYNTHETIC, 4096, ModuleDescriptor.Requires.Modifier.MANDATED, 32768);
    private static final Map<ModuleDescriptor.Exports.Modifier, Integer> EXPORTS_MODS_TO_FLAGS = Map.of(ModuleDescriptor.Exports.Modifier.SYNTHETIC, 4096, ModuleDescriptor.Exports.Modifier.MANDATED, 32768);
    private static final Map<ModuleDescriptor.Opens.Modifier, Integer> OPENS_MODS_TO_FLAGS = Map.of(ModuleDescriptor.Opens.Modifier.SYNTHETIC, 4096, ModuleDescriptor.Opens.Modifier.MANDATED, 32768);

    private ModuleInfoWriter() {
    }

    private static byte[] toModuleInfo(ModuleDescriptor md, ModuleResolution mres, ModuleTarget target) {
        return ClassFile.of().build(ClassDesc.of("module-info"), clb -> {
            clb.withFlags(new AccessFlag[]{AccessFlag.MODULE});
            ConstantPoolBuilder cp = clb.constantPool();
            clb.with((ClassFileElement)ModuleAttribute.of((ModuleEntry)cp.moduleEntry(cp.utf8Entry(md.name())), mb -> {
                ModuleEntry[] targets;
                int flags;
                mb.moduleFlags(md.modifiers().stream().mapToInt(mm -> MODULE_MODS_TO_FLAGS.getOrDefault(mm, 0)).reduce(0, (x, y) -> x | y));
                md.rawVersion().ifPresent(vs -> mb.moduleVersion(vs));
                for (ModuleDescriptor.Requires r : md.requires()) {
                    flags = r.modifiers().stream().mapToInt(REQUIRES_MODS_TO_FLAGS::get).reduce(0, (x, y) -> x | y);
                    mb.requires(ModuleRequireInfo.of((ModuleEntry)cp.moduleEntry(cp.utf8Entry(r.name())), (int)flags, (Utf8Entry)r.rawCompiledVersion().map(arg_0 -> ((ConstantPoolBuilder)cp).utf8Entry(arg_0)).orElse(null)));
                }
                for (ModuleDescriptor.Exports e : md.exports()) {
                    flags = e.modifiers().stream().mapToInt(EXPORTS_MODS_TO_FLAGS::get).reduce(0, (x, y) -> x | y);
                    targets = (ModuleEntry[])e.targets().stream().map(mn -> cp.moduleEntry(cp.utf8Entry(mn))).toArray(ModuleEntry[]::new);
                    mb.exports(ModuleExportInfo.of((PackageEntry)cp.packageEntry(cp.utf8Entry(e.source())), (int)flags, (ModuleEntry[])targets));
                }
                for (ModuleDescriptor.Opens opens : md.opens()) {
                    flags = opens.modifiers().stream().mapToInt(OPENS_MODS_TO_FLAGS::get).reduce(0, (x, y) -> x | y);
                    targets = (ModuleEntry[])opens.targets().stream().map(mn -> cp.moduleEntry(cp.utf8Entry(mn))).toArray(ModuleEntry[]::new);
                    mb.opens(ModuleOpenInfo.of((PackageEntry)cp.packageEntry(cp.utf8Entry(opens.source())), (int)flags, (ModuleEntry[])targets));
                }
                md.uses().stream().map(ClassDesc::of).forEach(arg_0 -> ((ModuleAttribute.ModuleAttributeBuilder)mb).uses(arg_0));
                for (ModuleDescriptor.Provides p : md.provides()) {
                    mb.provides(ClassDesc.of(p.service()), (ClassDesc[])p.providers().stream().map(ClassDesc::of).toArray(ClassDesc[]::new));
                }
            }));
            List<PackageDesc> packages = md.packages().stream().sorted().map(PackageDesc::of).toList();
            if (!packages.isEmpty()) {
                clb.with((ClassFileElement)ModulePackagesAttribute.ofNames(packages));
            }
            md.mainClass().ifPresent(mc -> clb.with((ClassFileElement)ModuleMainClassAttribute.of((ClassDesc)ClassDesc.of(mc))));
            if (mres != null) {
                clb.with((ClassFileElement)ModuleResolutionAttribute.of((int)mres.value()));
            }
            if (target != null && !target.targetPlatform().isEmpty()) {
                clb.with((ClassFileElement)ModuleTargetAttribute.of((String)target.targetPlatform()));
            }
        });
    }

    public static void write(ModuleDescriptor descriptor, ModuleResolution mres, ModuleTarget target, OutputStream out) throws IOException {
        byte[] bytes = ModuleInfoWriter.toModuleInfo(descriptor, mres, target);
        out.write(bytes);
    }

    public static void write(ModuleDescriptor descriptor, ModuleResolution mres, OutputStream out) throws IOException {
        ModuleInfoWriter.write(descriptor, mres, null, out);
    }

    public static void write(ModuleDescriptor descriptor, ModuleTarget target, OutputStream out) throws IOException {
        ModuleInfoWriter.write(descriptor, null, target, out);
    }

    public static void write(ModuleDescriptor descriptor, OutputStream out) throws IOException {
        ModuleInfoWriter.write(descriptor, null, null, out);
    }

    public static byte[] toBytes(ModuleDescriptor descriptor) {
        return ModuleInfoWriter.toModuleInfo(descriptor, null, null);
    }

    public static ByteBuffer toByteBuffer(ModuleDescriptor descriptor) {
        byte[] bytes = ModuleInfoWriter.toModuleInfo(descriptor, null, null);
        return ByteBuffer.wrap(bytes);
    }
}

