/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.util;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jdk.test.lib.Platform;

public final class FileUtils {
    private static final boolean IS_WINDOWS = Platform.isWindows();
    private static final int RETRY_DELETE_MILLIS = IS_WINDOWS ? 500 : 0;
    private static final int MAX_RETRY_DELETE_TIMES = IS_WINDOWS ? 15 : 0;
    private static volatile boolean nativeLibLoaded;
    static String[][] lsCommands;

    public static void deleteFileWithRetry(Path path) throws IOException {
        try {
            FileUtils.deleteFileWithRetry0(path);
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted while deleting.", x);
        }
    }

    public static void deleteFileIfExistsWithRetry(Path path) throws IOException {
        try {
            if (!Files.notExists(path, new LinkOption[0])) {
                FileUtils.deleteFileWithRetry0(path);
            }
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted while deleting.", x);
        }
    }

    private static void deleteFileWithRetry0(Path path) throws IOException, InterruptedException {
        int times = 0;
        IOException ioe = null;
        while (true) {
            try {
                Files.delete(path);
                while (!Files.notExists(path, new LinkOption[0])) {
                    if (++times > MAX_RETRY_DELETE_TIMES) {
                        throw new IOException("File still exists after " + times + " waits.");
                    }
                    Thread.sleep(RETRY_DELETE_MILLIS);
                }
            }
            catch (DirectoryNotEmptyException | NoSuchFileException x) {
                throw x;
            }
            catch (IOException x) {
                ++times;
                if (ioe == null) {
                    ioe = x;
                } else {
                    ioe.addSuppressed(x);
                }
                if (times > MAX_RETRY_DELETE_TIMES) {
                    throw ioe;
                }
                Thread.sleep(RETRY_DELETE_MILLIS);
                continue;
            }
            break;
        }
    }

    public static void deleteFileTreeWithRetry(Path dir) throws IOException {
        IOException ioe = null;
        List<IOException> excs = FileUtils.deleteFileTreeUnchecked(dir);
        if (!excs.isEmpty()) {
            ioe = excs.remove(0);
            for (IOException x : excs) {
                ioe.addSuppressed(x);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public static List<IOException> deleteFileTreeUnchecked(Path dir) {
        final ArrayList<IOException> excs = new ArrayList<IOException>();
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        FileUtils.deleteFileWithRetry0(file);
                    }
                    catch (IOException x) {
                        excs.add(x);
                    }
                    catch (InterruptedException x) {
                        excs.add(new IOException("Interrupted while deleting.", x));
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    try {
                        FileUtils.deleteFileWithRetry0(dir);
                    }
                    catch (IOException x) {
                        excs.add(x);
                    }
                    catch (InterruptedException x) {
                        excs.add(new IOException("Interrupted while deleting.", x));
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    excs.add(exc);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException x) {
            excs.add(x);
        }
        return excs;
    }

    public static boolean areFileSystemsAccessible() throws IOException {
        boolean areFileSystemsAccessible = true;
        if (!IS_WINDOWS) {
            System.out.println("\n--- df output ---");
            System.out.flush();
            Process proc = new ProcessBuilder("df").inheritIO().start();
            try {
                proc.waitFor(90L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                int exitValue = proc.exitValue();
                if (exitValue != 0) {
                    System.err.printf("df process exited with %d != 0%n", exitValue);
                    areFileSystemsAccessible = false;
                }
            }
            catch (IllegalThreadStateException ignored) {
                System.err.println("df command apparently hung");
                areFileSystemsAccessible = false;
            }
        }
        return areFileSystemsAccessible;
    }

    public static boolean areMountPointsAccessibleAndUnique() {
        if (IS_WINDOWS) {
            return true;
        }
        AtomicBoolean areMountPointsOK = new AtomicBoolean(true);
        Thread thr = new Thread(() -> {
            try {
                Process proc = new ProcessBuilder("df").start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                if (reader.readLine() != null) {
                    HashSet<String> mountPoints = new HashSet<String>();
                    String mountPoint = null;
                    while ((mountPoint = reader.readLine()) != null) {
                        if (mountPoints.add(mountPoint)) continue;
                        System.err.printf("Config error: duplicate mount point %s%n", mountPoint);
                        areMountPointsOK.set(false);
                        break;
                    }
                }
                try {
                    proc.waitFor(90L, TimeUnit.SECONDS);
                }
                catch (InterruptedException mountPoints) {
                    // empty catch block
                }
                try {
                    int exitValue = proc.exitValue();
                    if (exitValue != 0) {
                        System.err.printf("df process exited with %d != 0%n", exitValue);
                        areMountPointsOK.set(false);
                    }
                }
                catch (IllegalThreadStateException ignored) {
                    System.err.println("df command apparently hung");
                    areMountPointsOK.set(false);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
        final AtomicReference throwableReference = new AtomicReference();
        thr.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                throwableReference.set(e);
            }
        });
        thr.start();
        try {
            thr.join(120000L);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        Throwable uncaughtException = (Throwable)throwableReference.get();
        if (uncaughtException != null) {
            throw new RuntimeException(uncaughtException);
        }
        if (thr.isAlive()) {
            throw new RuntimeException("df thread did not join in time");
        }
        return areMountPointsOK.get();
    }

    public static void listFileDescriptors(PrintStream ps) {
        Optional<String[]> lsof = Arrays.stream(lsCommands).filter(args -> Files.isExecutable(Path.of(args[0], new String[0]))).findFirst();
        lsof.ifPresent(args -> {
            try {
                ps.printf("Open File Descriptors:%n", new Object[0]);
                long pid = ProcessHandle.current().pid();
                ProcessBuilder pb = new ProcessBuilder(args[0], args[1], Integer.toString((int)pid));
                pb.redirectErrorStream(true);
                pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
                Process p = pb.start();
                Instant start = Instant.now();
                p.getInputStream().transferTo(ps);
                try {
                    int timeout = 10;
                    if (!p.waitFor(timeout, TimeUnit.SECONDS)) {
                        System.out.printf("waitFor timed out: %d%n", timeout);
                    }
                }
                catch (InterruptedException ie) {
                    throw new IOException("interrupted", ie);
                }
                ps.println();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("error listing file descriptors", ioe);
            }
        });
    }

    public static long getProcessHandleCount() {
        if (IS_WINDOWS) {
            if (!nativeLibLoaded) {
                System.loadLibrary("FileUtils");
                nativeLibLoaded = true;
            }
            return FileUtils.getWinProcessHandleCount();
        }
        return ((UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getOpenFileDescriptorCount();
    }

    public static void patch(Path path, int fromLine, int toLine, String from, String to) throws IOException {
        String wantToRemove;
        String actuallyRemoved;
        List<String> lines = Files.readAllLines(path);
        List<String> subList = lines.subList(fromLine - 1, toLine);
        if (from != null && !(actuallyRemoved = subList.stream().map(String::trim).collect(Collectors.joining("\n")).trim()).equals(wantToRemove = from.lines().map(String::trim).collect(Collectors.joining("\n")).trim())) {
            throw new IOException("Removed not the same: [" + String.join((CharSequence)"\\n", subList) + "] and [" + from.replaceAll("\\n", "\\\\n") + "]");
        }
        subList.clear();
        lines.addAll(fromLine - 1, to.lines().toList());
        Files.write(path, lines, new OpenOption[0]);
    }

    private static native long getWinProcessHandleCount();

    static {
        lsCommands = new String[][]{{"/usr/bin/lsof", "-p"}, {"/usr/sbin/lsof", "-p"}, {"/bin/lsof", "-p"}, {"/sbin/lsof", "-p"}, {"/usr/local/bin/lsof", "-p"}};
    }
}

