/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal.lifecycle;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.internal.lifecycle.AbstractLifecycleMappingResolution;
import org.eclipse.osgi.util.NLS;

public class ConflictingLifecycleMappingResolution
extends AbstractLifecycleMappingResolution {
    private String prefix;

    public ConflictingLifecycleMappingResolution(IMarker marker, int index) {
        super(marker, PluginExecutionAction.ignore);
        this.prefix = "duplicateMappingSources." + index + ".";
    }

    public String getLabel() {
        String source = this.getMarker().getAttribute(this.prefix + "name", "");
        String type = this.getMarker().getAttribute("duplicateMappingType", "");
        String value = this.getMarker().getAttribute("duplicateMappingValue", "");
        return NLS.bind((String)Messages.LifecycleMappingProposal_sourceIgnore_label, (Object[])new Object[]{source, type, value});
    }

    protected void fix(IResource resource, List<IMarker> markers, IProgressMonitor monitor) {
        this.fix(markers, monitor);
    }

    protected void fix(IDocument document, List<IMarker> markers, IProgressMonitor monitor) {
        this.fix(markers, monitor);
    }

    private void fix(List<IMarker> markers, IProgressMonitor monitor) {
        LifecycleMappingMetadataSource mapping = LifecycleMappingFactory.getWorkspaceMetadata((boolean)true);
        for (IMarker marker : markers) {
            this.addMapping(mapping, marker);
        }
        LifecycleMappingFactory.writeWorkspaceMetadata((LifecycleMappingMetadataSource)mapping);
        new UpdateMavenProjectJob((Collection)this.getProjects(markers.stream())).schedule();
    }

    private void addMapping(LifecycleMappingMetadataSource mapping, IMarker marker) {
        String bsn = marker.getAttribute(this.prefix + "bundleSymbolicName", "");
        String version = marker.getAttribute(this.prefix + "bundleVersionRange", "");
        String type = marker.getAttribute("duplicateMappingType", "");
        String value = marker.getAttribute("duplicateMappingValue", "");
        if ("packaging".equals(type)) {
            LifecycleMappingFactory.addLifecycleMappingPackagingFilter((LifecycleMappingMetadataSource)mapping, (String)bsn, (String)version, (String)value);
        } else if ("goal".equals(type)) {
            String executionGroupId = marker.getAttribute("groupId", "");
            String executionArtifactId = marker.getAttribute("artifactId", "");
            String executionVersion = marker.getAttribute("version", "");
            String goal = marker.getAttribute("goal", "");
            LifecycleMappingFactory.addLifecycleMappingExecutionFilter((LifecycleMappingMetadataSource)mapping, (String)bsn, (String)version, (String)executionGroupId, (String)executionArtifactId, (String)executionVersion, (String)goal);
        }
    }
}

