/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.model.js.IScoutJsElement;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModels;
import org.eclipse.scout.sdk.core.s.model.js.objects.ScoutJsObjectQuery;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectType;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMapReference;
import org.eclipse.scout.sdk.core.s.widgetmap.Type;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public abstract class IdObjectTypeMap
extends Type {
    private final IObjectLiteral m_model;
    private final FinalValue<Optional<ScoutJsModel>> m_scoutJsModel = new FinalValue();
    private final Map<String, Optional<IES6Class>> m_classes = new HashMap<String, Optional<IES6Class>>();
    private final FinalValue<Map<String, IdObjectType>> m_elements = new FinalValue();
    private final FinalValue<Set<IdObjectTypeMapReference>> m_idObjectTypeMapReferences = new FinalValue();

    protected IdObjectTypeMap(String name, IObjectLiteral model, Collection<String> usedNames) {
        super((CharSequence)Ensure.notNull((Object)name), usedNames);
        this.m_model = (IObjectLiteral)Ensure.notNull((Object)model);
    }

    public IObjectLiteral model() {
        return this.m_model;
    }

    @Override
    public Type withNewClassName(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    public String name() {
        return this.newClassName().orElseThrow();
    }

    protected Optional<ScoutJsModel> scoutJsModel() {
        return (Optional)this.m_scoutJsModel.setIfAbsentAndGet(ScoutJsModels.create(this.model().containingModule()));
    }

    protected Optional<IES6Class> widgetClass() {
        return this.scoutJsModel().map(ScoutJsModel::widgetClass);
    }

    protected Optional<IES6Class> classByObjectType(String objectType) {
        return this.m_classes.computeIfAbsent(objectType, ot -> this.scoutJsModel().flatMap(model -> ((ScoutJsObjectQuery)((Object)((Object)((Object)model.findScoutObjects().withIncludeDependencies(true))))).withObjectType((String)ot).first().map(IScoutJsElement::declaringClass)));
    }

    public Map<String, IdObjectType> elements() {
        return (Map)this.m_elements.computeIfAbsentAndGet(this::parseElements);
    }

    protected abstract Map<String, IdObjectType> parseElements();

    public Set<IdObjectTypeMapReference> idObjectTypeMapReferences() {
        return (Set)this.m_idObjectTypeMapReferences.computeIfAbsentAndGet(this::parseIdObjectTypeMapReferences);
    }

    protected abstract Set<IdObjectTypeMapReference> parseIdObjectTypeMapReferences();

    public boolean isEmpty() {
        return this.isElementsEmpty() && this.isIdObjectTypeMapReferencesEmpty();
    }

    protected boolean isElementsEmpty() {
        return this.elements().isEmpty();
    }

    protected boolean isIdObjectTypeMapReferencesEmpty() {
        return this.idObjectTypeMapReferences().isEmpty();
    }

    protected void createDuplicateIdWarning(String id) {
        SdkLog.warning((CharSequence)"Duplicate id '{}' in model '{}'.", (Object[])new Object[]{id, this.model().containingFile().map(Path::toString).orElse(this.name())});
    }
}

