/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDSwitch;

public class XSDChildUtility {
    public static List getModelChildren(Object model) {
        XSDChildVisitor visitor = new XSDChildVisitor(model);
        visitor.visitXSDObject(model);
        return visitor.list;
    }

    public static List getImmediateDerivedTypes(XSDComplexTypeDefinition complexType) {
        ArrayList<XSDTypeDefinition> typesDerivedFrom = new ArrayList<XSDTypeDefinition>();
        EList typedefs = complexType.getSchema().getTypeDefinitions();
        Iterator iter = typedefs.iterator();
        while (iter.hasNext()) {
            XSDTypeDefinition typedef = (XSDTypeDefinition)iter.next();
            if (!complexType.equals(typedef.getBaseType())) continue;
            typesDerivedFrom.add(typedef);
        }
        return typesDerivedFrom;
    }

    public static class XSDChildVisitor
    extends XSDVisitor {
        Object root;
        List list = new ArrayList();

        public XSDChildVisitor(Object root) {
            this.root = root;
        }

        public void visitXSDModelGroup(XSDModelGroup xsdModelGroup) {
            if (xsdModelGroup != this.root) {
                this.list.add(xsdModelGroup);
            } else {
                super.visitXSDModelGroup(xsdModelGroup);
            }
        }

        public void visitXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
            if (xsdModelGroupDefinition != this.root) {
                this.list.add(xsdModelGroupDefinition);
            } else {
                super.visitXSDModelGroupDefinition(xsdModelGroupDefinition);
            }
        }

        public void visitXSDElementDeclaration(XSDElementDeclaration xsdElementDeclaration) {
            if (xsdElementDeclaration != this.root) {
                this.list.add(xsdElementDeclaration);
            } else {
                super.visitXSDElementDeclaration(xsdElementDeclaration);
            }
        }

        public void visitXSDComplexTypeDefinition(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            if (xsdComplexTypeDefinition != this.root) {
                if (xsdComplexTypeDefinition.getName() != null || XSDChildUtility.getModelChildren(xsdComplexTypeDefinition).size() > 0) {
                    this.list.add(xsdComplexTypeDefinition);
                }
            } else {
                super.visitXSDComplexTypeDefinition(xsdComplexTypeDefinition);
            }
        }

        public void visitXSDWildcard(XSDWildcard xsdWildCard) {
            if (xsdWildCard != this.root) {
                this.list.add(xsdWildCard);
            } else {
                super.visitXSDWildcard(xsdWildCard);
            }
        }
    }

    public static class XSDVisitor {
        int indent = 0;

        public void visitXSDObject(Object object) {
            if (object == null) {
                return;
            }
            XSDSwitch theSwitch = new XSDSwitch(this){
                final /* synthetic */ XSDVisitor this$1;
                {
                    this.this$1 = xSDVisitor;
                }

                public Object caseXSDComplexTypeDefinition(XSDComplexTypeDefinition object) {
                    this.this$1.visitXSDComplexTypeDefinition(object);
                    return null;
                }

                public Object caseXSDAttributeUse(XSDAttributeUse object) {
                    this.this$1.visitXSDAttributeUse(object);
                    return null;
                }

                public Object caseXSDElementDeclaration(XSDElementDeclaration object) {
                    this.this$1.visitXSDElementDeclaration(object);
                    return null;
                }

                public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition object) {
                    this.this$1.visitXSDModelGroupDefinition(object);
                    return super.caseXSDModelGroupDefinition(object);
                }

                public Object caseXSDModelGroup(XSDModelGroup object) {
                    this.this$1.visitXSDModelGroup(object);
                    return super.caseXSDModelGroup(object);
                }

                public Object caseXSDParticle(XSDParticle object) {
                    this.this$1.visitXSDParticle(object);
                    return null;
                }

                public Object caseXSDSchema(XSDSchema object) {
                    this.this$1.visitXSDSchema(object);
                    return null;
                }

                public Object caseXSDWildcard(XSDWildcard object) {
                    this.this$1.visitXSDWildcard(object);
                    return null;
                }
            };
            theSwitch.doSwitch((EObject)object);
        }

        public void visitXSDAttributeUse(XSDAttributeUse xsdAttributeUse) {
        }

        public void visitXSDSchema(XSDSchema xsdSchema) {
            this.indent += 2;
            Iterator iterator = xsdSchema.getElementDeclarations().iterator();
            while (iterator.hasNext()) {
                this.visitXSDObject(iterator.next());
            }
            this.indent -= 2;
        }

        public void visitXSDElementDeclaration(XSDElementDeclaration xsdElementDeclaration) {
            this.indent += 2;
            XSDTypeDefinition td = xsdElementDeclaration.getTypeDefinition();
            if (td == null) {
                td = xsdElementDeclaration.getAnonymousTypeDefinition();
            }
            this.visitXSDObject(td);
            this.indent -= 2;
        }

        public void visitXSDComplexTypeDefinition(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            this.indent += 2;
            Iterator i = xsdComplexTypeDefinition.getAttributeUses().iterator();
            while (i.hasNext()) {
                this.visitXSDObject(i.next());
            }
            this.visitXSDObject(xsdComplexTypeDefinition.getContent());
            this.indent -= 2;
        }

        public void visitXSDModelGroup(XSDModelGroup xsdModelGroup) {
            this.indent += 2;
            Iterator iterator = xsdModelGroup.getContents().iterator();
            while (iterator.hasNext()) {
                this.visitXSDObject(iterator.next());
            }
            this.indent -= 2;
        }

        public void visitXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
            this.indent += 2;
            this.visitXSDObject(xsdModelGroupDefinition.getResolvedModelGroupDefinition().getModelGroup());
            this.indent -= 2;
        }

        public void visitXSDParticle(XSDParticle xsdParticle) {
            this.indent += 2;
            if (xsdParticle.getContent() != null) {
                this.visitXSDObject(xsdParticle.getContent());
            }
            this.indent -= 2;
        }

        public void visitXSDWildcard(XSDWildcard object) {
        }

        public void printIndented(String string) {
        }
    }
}

