/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.visitor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.wsdl.ui.internal.adapters.visitor.W11XSDVisitor;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;

public class W11XSDVisitorForFields
extends W11XSDVisitor {
    List concreteComponentList = new ArrayList();
    List thingsWeNeedToListenTo = new ArrayList();

    @Override
    public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
        super.visitComplexTypeDefinition(type);
        if (type.getAttributeContents() != null) {
            for (XSDAttributeGroupContent attrGroupContent : type.getAttributeContents()) {
                if (attrGroupContent instanceof XSDAttributeUse) {
                    XSDAttributeUse attrUse = (XSDAttributeUse)attrGroupContent;
                    this.concreteComponentList.add(attrUse);
                    continue;
                }
                if (!(attrGroupContent instanceof XSDAttributeGroupDefinition)) continue;
                XSDAttributeGroupDefinition attrGroup = (XSDAttributeGroupDefinition)attrGroupContent;
                this.thingsWeNeedToListenTo.add(attrGroup);
                this.visitAttributeGroupDefinition(attrGroup);
            }
        }
    }

    @Override
    public void visitModelGroup(XSDModelGroup modelGroup) {
        super.visitModelGroup(modelGroup);
        this.thingsWeNeedToListenTo.add(modelGroup);
    }

    @Override
    public void visitAttributeGroupDefinition(XSDAttributeGroupDefinition attributeGroup) {
        for (Object o : attributeGroup.getContents()) {
            if (o instanceof XSDAttributeUse) {
                XSDAttributeUse attributeUse = (XSDAttributeUse)o;
                this.concreteComponentList.add(attributeUse);
                continue;
            }
            if (!(o instanceof XSDAttributeGroupDefinition)) continue;
            XSDAttributeGroupDefinition attrGroup = (XSDAttributeGroupDefinition)o;
            this.thingsWeNeedToListenTo.add(attrGroup);
            if (!attrGroup.isAttributeGroupDefinitionReference()) continue;
            attrGroup = attrGroup.getResolvedAttributeGroupDefinition();
            this.visitAttributeGroupDefinition(attrGroup);
        }
    }

    @Override
    public void visitElementDeclaration(XSDElementDeclaration element) {
        this.concreteComponentList.add(element);
    }

    @Override
    public void visitAttributeDeclaration(XSDAttributeDeclaration attr) {
        super.visitAttributeDeclaration(attr);
        this.concreteComponentList.add(attr);
    }

    public List getConcreteComponentList() {
        return this.concreteComponentList;
    }

    public List getThingsWeNeedToListenTo() {
        return this.thingsWeNeedToListenTo;
    }
}

