/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ServiceConfigurationError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageLoader;

public final class ImageUtils {
    private static Boolean isSvgSupported;

    private ImageUtils() {
        throw new IllegalStateException("Must never be instantiated");
    }

    public static String getEffectiveFileName(String fileName) {
        if (!ImageUtils.isSvgSupported() && fileName.endsWith(".svg")) {
            return fileName.replaceFirst("\\.svg$", ".png");
        }
        return fileName;
    }

    public static boolean isSvgSupported() {
        if (isSvgSupported != null) {
            return isSvgSupported;
        }
        String svg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<svg width=\"1\" height=\"1\" version=\"1.1\" viewBox=\"0 0 0 0\" xmlns=\"http://www.w3.org/2000/svg\"></svg>\n";
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(svg.getBytes(StandardCharsets.UTF_8));){
                new ImageLoader().load((InputStream)is);
                isSvgSupported = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ignore) {
            isSvgSupported = false;
        }
        catch (ServiceConfigurationError | SWTException e) {
            isSvgSupported = false;
        }
        return isSvgSupported;
    }
}

