/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.util.List;
import java.util.Objects;
import org.eclipse.passage.lic.base.version.DefaultVersion;
import org.eclipse.passage.lic.base.version.NumericalVersion;
import org.eclipse.passage.lic.base.version.SafeVersion;

public final class RequiredVersionVsAllowedVersion {
    private final String required;
    private final String allowed;
    private final String defaultVersion = new DefaultVersion().value();

    public RequiredVersionVsAllowedVersion(String required, String allowed) {
        Objects.requireNonNull(required, "MatchRuleParsing::requires");
        Objects.requireNonNull(allowed, "MatchRuleParsing::allowed");
        this.required = required;
        this.allowed = allowed;
    }

    public boolean match(int equals) {
        List<Integer> actual;
        if (Objects.equals(this.required, this.allowed)) {
            return true;
        }
        if (this.defaultVersion.equals(this.required)) {
            return true;
        }
        List<Integer> expected = this.segments(this.allowed);
        if (!this.headsAreEqual(expected, actual = this.segments(this.required), equals)) {
            return false;
        }
        return expected.get(equals) <= actual.get(equals);
    }

    private List<Integer> segments(String raw) {
        return new NumericalVersion(new SafeVersion(raw).semantic()).get();
    }

    private boolean headsAreEqual(List<Integer> expected, List<Integer> actual, int length) {
        int i = 0;
        while (i < length) {
            if (expected.get(i) != actual.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

