/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiErrorsWarningsConfigurationBlock;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.pde.api.tools.ui.internal.preferences.ProjectSelectionDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ApiErrorsWarningsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String DATA_SELECT_OPTION_KEY = "select_option_key";
    public static final String DATA_SELECT_OPTION_QUALIFIER = "select_option_qualifier";
    public static final String USE_PROJECT_SPECIFIC_OPTIONS = "use_project_specific_key";
    public static final String ID = "org.eclipse.pde.api.tools.ui.apitools.errorwarnings.prefpage";
    public static final String NO_LINK = "PropertyAndPreferencePage.nolink";
    public static final String INITIAL_TAB = "PropertyAndPreferencePage.initialTab";
    ApiErrorsWarningsConfigurationBlock block = null;
    private Link link = null;
    private Map<String, Object> fPageData = null;

    public ApiErrorsWarningsPreferencePage() {
        super(PreferenceMessages.ApiErrorsWarningsPreferencePage_0);
    }

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        this.link = new Link(comp, 0);
        this.link.setLayoutData((Object)new GridData(3, 2, true, false));
        this.link.setFont(comp.getFont());
        this.link.setText(PreferenceMessages.ApiErrorsWarningsPreferencePage_1);
        this.link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            HashSet<IJavaProject> set = new HashSet<IJavaProject>();
            try {
                IJavaProject[] projects;
                IJavaProject[] iJavaProjectArray = projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject p = iJavaProjectArray[n2];
                    IProject project = p.getProject();
                    if (Util.isApiProject((IProject)project) && this.block.hasProjectSpecificSettings(project)) {
                        set.add(p);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException projects) {
                // empty catch block
            }
            ProjectSelectionDialog psd = new ProjectSelectionDialog(this.getShell(), set);
            if (psd.open() == 0) {
                HashMap<String, Boolean> data = new HashMap<String, Boolean>();
                data.put(NO_LINK, Boolean.TRUE);
                PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)((IJavaProject)psd.getFirstResult()).getProject(), (String)"org.eclipse.pde.api.tools.ui.apitools.warningspage", (String[])new String[]{"org.eclipse.pde.api.tools.ui.apitools.warningspage"}, data).open();
            }
        }));
        this.block = new ApiErrorsWarningsConfigurationBlock(null, (IWorkbenchPreferenceContainer)this.getContainer());
        this.block.createControl(comp);
        this.applyData(this.fPageData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IApiToolsHelpContextIds.APITOOLS_ERROR_WARNING_PREF_PAGE);
        return comp;
    }

    public void dispose() {
        if (this.block != null) {
            this.block.dispose();
        }
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        this.block.performCancel();
        return super.performCancel();
    }

    public boolean performOk() {
        this.block.performOK();
        return super.performOk();
    }

    protected void performApply() {
        this.block.performApply();
        super.performApply();
    }

    protected void performDefaults() {
        this.block.performDefaults();
        super.performDefaults();
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            Integer tabIndex;
            this.fPageData = (Map)data;
            if (this.link != null && this.fPageData.containsKey(NO_LINK)) {
                this.link.setVisible(!Boolean.TRUE.equals(this.fPageData.get(NO_LINK)));
            }
            if (this.block != null && this.fPageData.containsKey(INITIAL_TAB) && (tabIndex = (Integer)this.fPageData.get(INITIAL_TAB)) != null) {
                try {
                    this.block.selectTab(tabIndex);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.block == null) {
                return;
            }
            Integer tab = (Integer)this.fPageData.get(INITIAL_TAB);
            if (tab != null) {
                this.block.selectTab(tab);
            }
            Object key = this.fPageData.get(DATA_SELECT_OPTION_KEY);
            Object qualifier = this.fPageData.get(DATA_SELECT_OPTION_QUALIFIER);
            if (key instanceof String && qualifier instanceof String) {
                this.block.selectOption((String)key, (String)qualifier);
            }
        }
    }
}

