/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Font;

public class ScriptSourcePreviewerUpdater {
    public ScriptSourcePreviewerUpdater(SourceViewer viewer, ScriptSourceViewerConfiguration configuration, IPreferenceStore preferenceStore) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)((Object)configuration));
        Assert.isNotNull((Object)preferenceStore);
        IPropertyChangeListener fontChangeListener = event -> {
            String fontKey = configuration.getFontPropertyPreferenceKey();
            if (fontKey.equals(event.getProperty())) {
                Font font = JFaceResources.getFont((String)fontKey);
                viewer.getTextWidget().setFont(font);
            }
        };
        IPropertyChangeListener propertyChangeListener = event -> {
            if (configuration.affectsTextPresentation(event)) {
                configuration.handlePropertyChangeEvent(event);
                viewer.invalidateTextPresentation();
            }
        };
        viewer.getTextWidget().addDisposeListener(e -> {
            preferenceStore.removePropertyChangeListener(propertyChangeListener);
            JFaceResources.getFontRegistry().removeListener(fontChangeListener);
        });
        JFaceResources.getFontRegistry().addListener(fontChangeListener);
        preferenceStore.addPropertyChangeListener(propertyChangeListener);
    }
}

