/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.logicalstructure.util;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;

public class Scope {
    private static final int INFO_EVALUATION_STACK_FRAME = 111;
    private static final IStatus NEED_STACK_FRAME = new Status(1, "org.eclipse.emf.cdo.ecore.logicalstructure", 111, "Provides thread context for an evaluation", null);
    private static final Map<IDebugTarget, Map<String, ICompiledExpression>> CACHE = new WeakHashMap<IDebugTarget, Map<String, ICompiledExpression>>();
    private static IStatusHandler stackFrameProvider;
    private final IJavaObject value;
    private final IJavaReferenceType type;
    private final IJavaThread thread;
    private final IAstEvaluationEngine evaluationEngine;

    public Scope(IJavaObject value, IJavaReferenceType type, IJavaThread thread, IAstEvaluationEngine evaluationEngine) {
        this.value = value;
        this.type = type;
        this.thread = thread;
        this.evaluationEngine = evaluationEngine;
    }

    public String getModelIdentifier() {
        return this.value.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.value.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.value.getLaunch();
    }

    public IJavaObject getValue() {
        return this.value;
    }

    public IJavaReferenceType getType() {
        return this.type;
    }

    public IJavaValue evaluate(String expression) throws DebugException {
        ICompiledExpression compiledExpression = this.getCompiledExpression(expression);
        ResultListener listener = new ResultListener();
        this.evaluationEngine.evaluateExpression(compiledExpression, this.value, this.thread, (IEvaluationListener)listener, 128, false);
        IEvaluationResult result = listener.getResult();
        if (result == null) {
            return null;
        }
        if (result.hasErrors()) {
            StringBuilder message = new StringBuilder("Error when evaluating expression ");
            message.append(expression);
            message.append(": ");
            String[] errorMessages = result.getErrorMessages();
            int i = 0;
            while (i < errorMessages.length) {
                message.append(errorMessages[i]);
                message.append("\n");
                ++i;
            }
            throw new DebugException((IStatus)new Status(4, "org.eclipse.emf.cdo.ecore.logicalstructure", message.toString(), (Throwable)result.getException()));
        }
        return result.getValue();
    }

    private ICompiledExpression getCompiledExpression(String expression) throws DebugException {
        ICompiledExpression compiledExpression;
        IDebugTarget debugTarget = this.value.getDebugTarget();
        Map<String, ICompiledExpression> compiledExpressions = CACHE.get(debugTarget);
        if (compiledExpressions == null) {
            compiledExpressions = new HashMap<String, ICompiledExpression>();
            CACHE.put(debugTarget, compiledExpressions);
        }
        if ((compiledExpression = compiledExpressions.get(expression)) == null) {
            compiledExpression = this.compile(expression);
            compiledExpressions.put(expression, compiledExpression);
        }
        return compiledExpression;
    }

    private ICompiledExpression compile(String expression) throws DebugException {
        ICompiledExpression compiledExpression = this.evaluationEngine.getCompiledExpression(expression, this.type);
        if (compiledExpression.hasErrors()) {
            StringBuilder message = new StringBuilder("Error when compiling expression ");
            message.append(expression);
            message.append(": ");
            String[] errorMessages = compiledExpression.getErrorMessages();
            int i = 0;
            while (i < errorMessages.length) {
                message.append(errorMessages[i]);
                message.append("\n");
                ++i;
            }
            throw new DebugException((IStatus)new Status(4, "org.eclipse.emf.cdo.ecore.logicalstructure", message.toString()));
        }
        return compiledExpression;
    }

    public static Scope create(IJavaObject value) throws CoreException {
        IJavaStackFrame stackFrame;
        Scope scope = null;
        IJavaType type = value.getJavaType();
        if (type instanceof IJavaClassType && (stackFrame = Scope.getStackFrame((IValue)value)) != null) {
            IJavaProject resourceProject;
            Object newSourceElement;
            ISourceLocator locator = value.getLaunch().getSourceLocator();
            Object sourceElement = null;
            if (locator instanceof ISourceLookupDirector) {
                String[] sourcePaths = ((IJavaClassType)type).getSourcePaths(null);
                if (sourcePaths != null && sourcePaths.length > 0) {
                    sourceElement = ((ISourceLookupDirector)locator).getSourceElement((Object)sourcePaths[0]);
                }
                if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
                    sourceElement = ((IAdaptable)sourceElement).getAdapter(IJavaElement.class);
                }
            }
            if (sourceElement == null && !((sourceElement = locator.getSourceElement((IStackFrame)stackFrame)) instanceof IJavaElement) && sourceElement instanceof IAdaptable && (newSourceElement = ((IAdaptable)sourceElement).getAdapter(IJavaElement.class)) != null) {
                sourceElement = newSourceElement;
            }
            IJavaProject project = null;
            if (sourceElement instanceof IJavaElement) {
                project = ((IJavaElement)sourceElement).getJavaProject();
            } else if (sourceElement instanceof IResource && (resourceProject = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
                project = resourceProject;
            }
            if (project != null) {
                IJavaDebugTarget debugTarget = (IJavaDebugTarget)stackFrame.getDebugTarget();
                IAstEvaluationEngine evaluationEngine = Scope.getEvaluationEngine(project, debugTarget);
                scope = new Scope(value, (IJavaReferenceType)type, (IJavaThread)stackFrame.getThread(), evaluationEngine);
            }
        }
        return scope;
    }

    private static IAstEvaluationEngine getEvaluationEngine(IJavaProject project, IJavaDebugTarget debugTarget) {
        return JDIDebugPlugin.getDefault().getEvaluationEngine(project, debugTarget);
    }

    private static IJavaStackFrame getStackFrame(IValue value) throws CoreException {
        IJavaStackFrame stackFrame;
        IStatusHandler handler = Scope.getStackFrameProvider();
        if (handler != null && (stackFrame = (IJavaStackFrame)handler.handleStatus(NEED_STACK_FRAME, (Object)value)) != null) {
            return stackFrame;
        }
        IDebugTarget target = value.getDebugTarget();
        IJavaDebugTarget javaTarget = (IJavaDebugTarget)target.getAdapter(IJavaDebugTarget.class);
        if (javaTarget != null) {
            IThread[] threads = javaTarget.getThreads();
            int i = 0;
            while (i < threads.length) {
                IThread thread = threads[i];
                if (thread.isSuspended()) {
                    return (IJavaStackFrame)thread.getTopStackFrame();
                }
                ++i;
            }
        }
        return null;
    }

    private static IStatusHandler getStackFrameProvider() {
        if (stackFrameProvider == null) {
            stackFrameProvider = DebugPlugin.getDefault().getStatusHandler(NEED_STACK_FRAME);
        }
        return stackFrameProvider;
    }

    private static final class ResultListener
    implements IEvaluationListener {
        private IEvaluationResult result;

        private ResultListener() {
        }

        public synchronized void evaluationComplete(IEvaluationResult result) {
            this.result = result;
            this.notifyAll();
        }

        public synchronized IEvaluationResult getResult() {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            return this.result;
        }
    }
}

