/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryEnum;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryType;
import org.eclipse.jpt.common.core.internal.resource.java.binary.RootBinaryModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceTypeCache;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class BinaryTypeCache
extends RootBinaryModel
implements JavaResourceTypeCache {
    private final Vector<Entry> entries = new Vector();
    private static final Transformer<Entry, JavaResourceAbstractType> ENTRY_TYPE_TRANSFORMER = new EntryTypeTransformer();

    public BinaryTypeCache(AnnotationProvider annotationProvider) {
        super(null, annotationProvider);
    }

    @Override
    public Iterable<JavaResourceAbstractType> getTypes() {
        return IterableTools.transform(this.getEntries(), ENTRY_TYPE_TRANSFORMER);
    }

    private Iterable<Entry> getEntries() {
        return IterableTools.cloneLive(this.entries);
    }

    @Override
    public int getTypesSize() {
        return this.entries.size();
    }

    @Override
    public JavaResourceAbstractType addType(IType jdtType) {
        Entry entry = this.buildEntry(jdtType);
        this.entries.add(entry);
        this.fireItemAdded("types", entry.type);
        return entry.type;
    }

    private Entry buildEntry(IType jdtType) {
        return new Entry(this.buildType(jdtType), jdtType.getResource());
    }

    private JavaResourceAbstractType buildType(IType jdtType) {
        try {
            if (jdtType.isClass() || jdtType.isInterface()) {
                return new BinaryType((JavaResourceModel)this, jdtType);
            }
            if (jdtType.isEnum()) {
                return new BinaryEnum((JavaResourceModel)this, jdtType);
            }
        }
        catch (JavaModelException e) {
            JptCommonCorePlugin.instance().logError(e);
        }
        return null;
    }

    @Override
    public boolean removeTypes(IFile jarFile) {
        boolean modified = false;
        for (Entry entry : this.getEntries()) {
            IResource resource = entry.resource;
            if (resource == null || !resource.equals((Object)jarFile)) continue;
            this.removeEntry(entry);
            modified = true;
        }
        return modified;
    }

    private void removeEntry(Entry entry) {
        this.entries.remove(entry);
        this.fireItemRemoved("types", entry.type);
    }

    @Override
    protected void aspectChanged(String aspectName) {
        if (aspectName != null && !aspectName.equals("types")) {
            super.aspectChanged(aspectName);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.entries);
    }

    static class Entry {
        final JavaResourceAbstractType type;
        final IResource resource;

        Entry(JavaResourceAbstractType type, IResource resource) {
            this.type = type;
            this.resource = resource;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.type);
        }
    }

    static class EntryTypeTransformer
    extends TransformerAdapter<Entry, JavaResourceAbstractType> {
        EntryTypeTransformer() {
        }

        public JavaResourceAbstractType transform(Entry entry) {
            return entry.type;
        }
    }
}

