/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Locale;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.STABLE, since="5.1")
public enum OS {
    AIX,
    FREEBSD,
    LINUX,
    MAC,
    OPENBSD,
    SOLARIS,
    WINDOWS,
    OTHER;

    private static final Logger logger;
    private static final @Nullable OS CURRENT_OS;

    @API(status=API.Status.STABLE, since="5.10")
    public static @Nullable OS current() {
        return CURRENT_OS;
    }

    private static @Nullable OS determineCurrentOs() {
        return OS.parse(System.getProperty("os.name"));
    }

    static @Nullable OS parse(String osName) {
        if (StringUtils.isBlank((String)osName)) {
            logger.debug(() -> "JVM system property 'os.name' is undefined. It is therefore not possible to detect the current OS.");
            return null;
        }
        if ((osName = osName.toLowerCase(Locale.ENGLISH)).contains("aix")) {
            return AIX;
        }
        if (osName.contains("freebsd")) {
            return FREEBSD;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        if (osName.contains("mac")) {
            return MAC;
        }
        if (osName.contains("openbsd")) {
            return OPENBSD;
        }
        if (osName.contains("sunos") || osName.contains("solaris")) {
            return SOLARIS;
        }
        if (osName.contains("win")) {
            return WINDOWS;
        }
        return OTHER;
    }

    public boolean isCurrentOs() {
        return this == CURRENT_OS;
    }

    static {
        logger = LoggerFactory.getLogger(OS.class);
        CURRENT_OS = OS.determineCurrentOs();
    }
}

