/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.notifications.feed;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.notifications.feed.RSSItem;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;

public class FeedEntry
extends ServiceMessage {
    private final RSSItem source;

    public FeedEntry(String eventId, RSSItem source) {
        super(eventId);
        this.source = source;
        this.setId(source.getGuid());
        this.setTitle(source.getTitle());
        if (source.getDescription() != null) {
            this.setDescription(source.getDescription());
        }
        this.setUrl(source.getLink());
        this.setImage("dialog_messasge_info_image");
        this.setDate(this.getDate(source));
    }

    private Date getDate(RSSItem source) {
        SimpleDateFormat sdf = new SimpleDateFormat("E, dd MMM yyyy hh:mm:ss ZZZZ", Locale.US);
        try {
            return sdf.parse(source.getPubDate());
        }
        catch (ParseException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.notifications.feed", "Processing pub date of \"" + String.valueOf(source) + "\" failed", (Throwable)e));
            return null;
        }
    }

    public FeedEntry(String eventId) {
        super(eventId);
        this.source = null;
    }

    public RSSItem getSource() {
        return this.source;
    }

    public List<String> getFilters(String key) {
        Assert.isNotNull((Object)key);
        ArrayList<String> result = new ArrayList<String>();
        if (this.source.getSubjects() != null) {
            for (String subject : this.source.getSubjects()) {
                String value = this.parseFilter(key, subject);
                if (value == null) continue;
                result.add(value);
            }
        }
        return result;
    }

    public String getFilter(String key) {
        Assert.isNotNull((Object)key);
        if (this.source.getSubjects() != null) {
            for (String subject : this.source.getSubjects()) {
                String value = this.parseFilter(key, subject);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    private String parseFilter(String key, String category) {
        int i;
        if (category != null && (i = category.indexOf("=")) != -1 && category.substring(0, i).trim().equals(key)) {
            return category.substring(i + 1).trim();
        }
        return null;
    }
}

