/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;

public abstract class MavenShowConsoleAction
extends Action
implements IPropertyChangeListener {
    public MavenShowConsoleAction(String name) {
        super(name, 2);
        this.setToolTipText(name);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(this.getKey())) {
            this.update();
        }
    }

    protected abstract String getKey();

    private void update() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean(this.getKey())) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return M2EUIPluginActivator.getDefault().getPreferenceStore();
    }

    public void run() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean show = this.isChecked();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
        store.setValue(this.getKey(), show);
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

