/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.launching.JavaClasspathVariablesInitializer;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.AdvancedSourceLookupSupport;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.sourcelookup.ArchiveSourceLocation;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchingPlugin
extends Plugin
implements DebugOptionsListener,
IEclipsePreferences.IPreferenceChangeListener,
IVMInstallChangedListener,
IResourceChangeListener,
ILaunchesListener,
IDebugEventSetListener {
    public static boolean DEBUG = false;
    public static boolean DEBUG_JRE_CONTAINER = false;
    public static final String DEBUG_JRE_CONTAINER_FLAG = "org.eclipse.jdt.launching/debug/classpath/jreContainer";
    public static final String DEBUG_FLAG = "org.eclipse.jdt.launching/debug";
    public static final String ATTR_LAUNCH_TEMP_FILES = "tempFiles";
    public static final String LAUNCH_TEMP_FILE_PREFIX = ".temp-";
    private static DebugTrace fgDebugTrace;
    public static final String ID_PLUGIN = "org.eclipse.jdt.launching";
    public static final String ID_EXTENSION_POINT_VM_CONNECTORS = "vmConnectors";
    public static final String ID_EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRIES = "runtimeClasspathEntries";
    private static LaunchingPlugin fgLaunchingPlugin;
    private final ConcurrentHashMap<String, IVMConnector> fVMConnectors = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IConfigurationElement> fClasspathEntryExtensions = new ConcurrentHashMap();
    private volatile String fOldVMPrefString = "";
    private volatile boolean fIgnoreVMDefPropertyChangeEvents;
    private static final String EMPTY_STRING = "";
    public static final String PREF_DETECT_VMS_AT_STARTUP = "detectVMsAtStartup";
    private static final ConcurrentHashMap<String, LibraryInfo> fgLibraryInfoMap;
    private static final ConcurrentHashMap<String, Long> fgInstallTimeMap;
    private static final Set<String> fgHasChanged;
    private static final Object installLock;
    private volatile boolean fBatchingChanges;
    private static volatile DocumentBuilder fgXMLParser;
    private ServiceTracker<IWorkspace, IWorkspace> fWorkspaceServiceTracker;

    static {
        fgLibraryInfoMap = new ConcurrentHashMap(10);
        fgInstallTimeMap = new ConcurrentHashMap();
        fgHasChanged = ConcurrentHashMap.newKeySet();
        installLock = new Object();
    }

    public LaunchingPlugin() {
        fgLaunchingPlugin = this;
    }

    public static LibraryInfo getLibraryInfo(String javaInstallPath) {
        if (fgLibraryInfoMap.isEmpty()) {
            LaunchingPlugin.restoreLibraryInfo();
        }
        return fgLibraryInfoMap.get(javaInstallPath);
    }

    public static void setLibraryInfo(String javaInstallPath, LibraryInfo info) {
        if (LaunchingPlugin.isVMLogging()) {
            LaunchingPlugin.log(LaunchingMessages.VMLogging_2 + javaInstallPath);
        }
        if (fgLibraryInfoMap.isEmpty()) {
            LaunchingPlugin.restoreLibraryInfo();
        }
        if (info == null) {
            fgLibraryInfoMap.remove(javaInstallPath);
            if (!fgInstallTimeMap.isEmpty()) {
                fgInstallTimeMap.remove(javaInstallPath);
                LaunchingPlugin.writeInstallInfo();
            }
        } else {
            fgLibraryInfoMap.put(javaInstallPath, info);
        }
        fgHasChanged.remove(javaInstallPath);
        LaunchingPlugin.saveLibraryInfo();
    }

    public static boolean isVMLogging() {
        String vmLogging = System.getProperty("jdt.debug.launching.vmLogging");
        return "true".equalsIgnoreCase(vmLogging);
    }

    public static File getFileInPlugin(IPath path) {
        try {
            URL installURL = new URL(LaunchingPlugin.getDefault().getBundle().getEntry("/"), path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static String getUniqueIdentifier() {
        return ID_PLUGIN;
    }

    public static LaunchingPlugin getDefault() {
        return fgLaunchingPlugin;
    }

    public static void log(IStatus status) {
        LaunchingPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        LaunchingPlugin.log((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        LaunchingPlugin.log((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public void stop(BundleContext context) throws Exception {
        try {
            AdvancedSourceLookupSupport.stop();
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            ArchiveSourceLocation.closeArchives();
            InstanceScope.INSTANCE.getNode(ID_PLUGIN).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            JavaRuntime.removeVMInstallChangedListener(this);
            JavaRuntime.saveVMConfiguration();
            fgXMLParser = null;
            this.fWorkspaceServiceTracker.close();
        }
        finally {
            super.stop(context);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", LaunchingPlugin.getUniqueIdentifier());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.fWorkspaceServiceTracker = new ServiceTracker<IWorkspace, IWorkspace>(context, IWorkspace.class, null){

            public IWorkspace addingService(ServiceReference<IWorkspace> reference) {
                IWorkspace workspace = (IWorkspace)this.context.getService(reference);
                if (workspace == null) {
                    LaunchingPlugin.log("Could not add save participant as IWorkspace service is unavailable");
                    return null;
                }
                try {
                    workspace.addSaveParticipant(LaunchingPlugin.ID_PLUGIN, new ISaveParticipant(){

                        public void doneSaving(ISaveContext context1) {
                        }

                        public void prepareToSave(ISaveContext context1) throws CoreException {
                        }

                        public void rollback(ISaveContext context1) {
                        }

                        public void saving(ISaveContext context1) throws CoreException {
                            try {
                                InstanceScope.INSTANCE.getNode(LaunchingPlugin.ID_PLUGIN).flush();
                            }
                            catch (BackingStoreException e) {
                                LaunchingPlugin.log(e);
                            }
                            LaunchingPlugin.writeInstallInfo();
                        }
                    });
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e.getStatus());
                    this.context.ungetService(reference);
                    return null;
                }
                return (IWorkspace)super.addingService(reference);
            }

            public void removedService(ServiceReference<IWorkspace> reference, IWorkspace service) {
                service.removeSaveParticipant(LaunchingPlugin.ID_PLUGIN);
                this.context.ungetService(reference);
            }
        };
        this.fWorkspaceServiceTracker.open();
        InstanceScope.INSTANCE.getNode(ID_PLUGIN).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        JavaRuntime.addVMInstallChangedListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 6);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        AdvancedSourceLookupSupport.start();
    }

    public IVMConnector getVMConnector(String id) {
        if (this.fVMConnectors.isEmpty()) {
            this.initializeVMConnectors();
        }
        return this.fVMConnectors.get(id);
    }

    public IVMConnector[] getVMConnectors() {
        if (this.fVMConnectors.isEmpty()) {
            this.initializeVMConnectors();
        }
        return this.fVMConnectors.values().toArray(new IVMConnector[0]);
    }

    private void initializeVMConnectors() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_PLUGIN, ID_EXTENSION_POINT_VM_CONNECTORS);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(LaunchingPlugin.getUniqueIdentifier(), 0, "Exception occurred reading vmConnectors extensions.", null);
        this.fVMConnectors.clear();
        int i = 0;
        while (i < configs.length) {
            try {
                IVMConnector vmConnector = (IVMConnector)configs[i].createExecutableExtension("class");
                this.fVMConnectors.put(vmConnector.getIdentifier(), vmConnector);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            LaunchingPlugin.log((IStatus)status);
        }
    }

    public IRuntimeClasspathEntry2 newRuntimeClasspathEntry(String id) throws CoreException {
        IConfigurationElement config;
        if (this.fClasspathEntryExtensions.isEmpty()) {
            this.initializeRuntimeClasspathExtensions();
        }
        if ((config = this.fClasspathEntryExtensions.get(id)) != null) {
            return (IRuntimeClasspathEntry2)config.createExecutableExtension("class");
        }
        LaunchingPlugin.abort(NLS.bind((String)LaunchingMessages.LaunchingPlugin_32, (Object)id), null);
        return null;
    }

    private void initializeRuntimeClasspathExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_PLUGIN, ID_EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRIES);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        this.fClasspathEntryExtensions.clear();
        int i = 0;
        while (i < configs.length) {
            this.fClasspathEntryExtensions.put(configs[i].getAttribute("id"), configs[i]);
            ++i;
        }
    }

    protected void processVMPrefsChanged(String oldValue, String newValue) {
        VMChanges vmChanges;
        block12: {
            block13: {
                this.fBatchingChanges = true;
                vmChanges = null;
                if (newValue != null && !newValue.equals(EMPTY_STRING)) break block12;
                this.fOldVMPrefString = oldValue;
                this.fBatchingChanges = false;
                if (vmChanges == null) break block13;
                JavaRuntime.removeVMInstallChangedListener(vmChanges);
                vmChanges.process();
            }
            return;
        }
        try {
            IVMInstall newDefaultVM;
            String newPrefString;
            String oldPrefString;
            if (oldValue == null || oldValue.equals(EMPTY_STRING)) {
                oldPrefString = this.fOldVMPrefString;
                newPrefString = newValue;
            } else {
                oldPrefString = oldValue;
                newPrefString = newValue;
            }
            vmChanges = new VMChanges();
            JavaRuntime.addVMInstallChangedListener(vmChanges);
            VMDefinitionsContainer oldResults = this.getVMDefinitions(oldPrefString);
            VMDefinitionsContainer newResults = this.getVMDefinitions(newPrefString);
            List<IVMInstall> deleted = oldResults.getVMList();
            List<IVMInstall> current = newResults.getValidVMList();
            deleted.removeAll(current);
            for (VMStandin vMStandin : deleted) {
                vMStandin.getVMInstallType().disposeVMInstall(vMStandin.getId());
            }
            for (VMStandin vMStandin : current) {
                vMStandin.convertToRealVM();
            }
            String string = newResults.getDefaultVMInstallCompositeID();
            if (string != null && (newDefaultVM = JavaRuntime.getVMFromCompositeId(string)) != null) {
                try {
                    JavaRuntime.setDefaultVMInstall(newDefaultVM, null, false);
                }
                catch (CoreException ce) {
                    LaunchingPlugin.log(ce);
                }
            }
        }
        catch (Throwable throwable) {
            this.fBatchingChanges = false;
            if (vmChanges != null) {
                JavaRuntime.removeVMInstallChangedListener(vmChanges);
                vmChanges.process();
            }
            throw throwable;
        }
        this.fBatchingChanges = false;
        if (vmChanges != null) {
            JavaRuntime.removeVMInstallChangedListener(vmChanges);
            vmChanges.process();
        }
    }

    private VMDefinitionsContainer getVMDefinitions(String xml) {
        if (xml.length() > 0) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
                return VMDefinitionsContainer.parseXMLIntoContainer(stream);
            }
            catch (IOException e) {
                LaunchingPlugin.log(e);
            }
        }
        return new VMDefinitionsContainer();
    }

    @Override
    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        if (!this.fBatchingChanges) {
            VMChanges changes = new VMChanges();
            changes.defaultVMInstallChanged(previous, current);
            changes.process();
        }
    }

    @Override
    public void vmAdded(IVMInstall vm) {
    }

    @Override
    public void vmChanged(PropertyChangeEvent event) {
        if (!this.fBatchingChanges) {
            VMChanges changes = new VMChanges();
            changes.vmChanged(event);
            changes.process();
        }
    }

    @Override
    public void vmRemoved(IVMInstall vm) {
        if (!this.fBatchingChanges) {
            VMChanges changes = new VMChanges();
            changes.vmRemoved(vm);
            changes.process();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        ArchiveSourceLocation.closeArchives();
    }

    public void setIgnoreVMDefPropertyChangeEvents(boolean ignore) {
        this.fIgnoreVMDefPropertyChangeEvents = ignore;
    }

    public boolean isIgnoreVMDefPropertyChangeEvents() {
        return this.fIgnoreVMDefPropertyChangeEvents;
    }

    private static String getLibraryInfoAsXML() throws CoreException {
        Document doc = DebugPlugin.newDocument();
        Element config = doc.createElement("libraryInfos");
        doc.appendChild(config);
        for (String home : fgLibraryInfoMap.keySet()) {
            LibraryInfo info = fgLibraryInfoMap.get(home);
            Element locationElemnet = LaunchingPlugin.infoAsElement(doc, info);
            locationElemnet.setAttribute("home", home);
            config.appendChild(locationElemnet);
        }
        return DebugPlugin.serializeDocument((Document)doc);
    }

    private static Element infoAsElement(Document doc, LibraryInfo info) {
        Element libraryElement = doc.createElement("libraryInfo");
        libraryElement.setAttribute("version", info.getVersion());
        LaunchingPlugin.appendPathElements(doc, "bootpath", libraryElement, info.getBootpath());
        LaunchingPlugin.appendPathElements(doc, "extensionDirs", libraryElement, info.getExtensionDirs());
        LaunchingPlugin.appendPathElements(doc, "endorsedDirs", libraryElement, info.getEndorsedDirs());
        return libraryElement;
    }

    private static void appendPathElements(Document doc, String elementType, Element libraryElement, String[] paths) {
        if (paths.length > 0) {
            Element child = doc.createElement(elementType);
            libraryElement.appendChild(child);
            int i = 0;
            while (i < paths.length) {
                String path = paths[i];
                Element entry = doc.createElement("entry");
                child.appendChild(entry);
                entry.setAttribute("path", path);
                ++i;
            }
        }
    }

    private static void saveLibraryInfo() {
        try {
            String xml = LaunchingPlugin.getLibraryInfoAsXML();
            IPath libPath = LaunchingPlugin.getDefault().getStateLocation();
            libPath = libPath.append("libraryInfos.xml");
            File file = libPath.toFile();
            if (!file.exists()) {
                file.createNewFile();
            }
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
                ((OutputStream)stream).write(xml.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        catch (CoreException e) {
            LaunchingPlugin.log(e);
        }
    }

    private static void restoreLibraryInfo() {
        fgLibraryInfoMap.clear();
        IPath libPath = LaunchingPlugin.getDefault().getStateLocation();
        libPath = libPath.append("libraryInfos.xml");
        File file = libPath.toFile();
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    DocumentBuilder parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
                    parser.setErrorHandler(new DefaultHandler());
                    Element root = parser.parse(new InputSource(stream)).getDocumentElement();
                    if (!root.getNodeName().equals("libraryInfos")) {
                        return;
                    }
                    NodeList list = root.getChildNodes();
                    int length = list.getLength();
                    int i = 0;
                    while (i < length) {
                        Element element;
                        String nodeName;
                        Node node = list.item(i);
                        short type = node.getNodeType();
                        if (type == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase("libraryInfo")) {
                            String version = element.getAttribute("version");
                            String location = element.getAttribute("home");
                            String[] bootpath = LaunchingPlugin.getPathsFromXML(element, "bootpath");
                            String[] extDirs = LaunchingPlugin.getPathsFromXML(element, "extensionDirs");
                            String[] endDirs = LaunchingPlugin.getPathsFromXML(element, "endorsedDirs");
                            if (location != null) {
                                if (LaunchingPlugin.isVMLogging()) {
                                    LaunchingPlugin.log(LaunchingMessages.VMLogging_1 + location);
                                }
                                LibraryInfo info = new LibraryInfo(version, bootpath, extDirs, endDirs);
                                fgLibraryInfoMap.put(location, info);
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean timeStampChanged(String location) {
        Object object = installLock;
        synchronized (object) {
            block8: {
                long fstamp;
                Long stamp;
                block9: {
                    block7: {
                        if (!fgHasChanged.contains(location)) break block7;
                        return true;
                    }
                    File file = new File(location);
                    if (!file.exists()) break block8;
                    if (fgInstallTimeMap.isEmpty()) {
                        LaunchingPlugin.readInstallInfo();
                    }
                    stamp = fgInstallTimeMap.get(location);
                    fstamp = file.lastModified();
                    if (stamp == null || stamp != fstamp) break block9;
                    return false;
                }
                stamp = fstamp;
                fgInstallTimeMap.put(location, stamp);
                LaunchingPlugin.writeInstallInfo();
                fgHasChanged.add(location);
                return true;
            }
        }
        return false;
    }

    private static void readInstallInfo() {
        block16: {
            fgInstallTimeMap.clear();
            IPath libPath = LaunchingPlugin.getDefault().getStateLocation();
            libPath = libPath.append(".install.xml");
            File file = libPath.toFile();
            if (file.exists()) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                        DocumentBuilder parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
                        parser.setErrorHandler(new DefaultHandler());
                        Element root = parser.parse(new InputSource(stream)).getDocumentElement();
                        if (!root.getNodeName().equalsIgnoreCase("dirs")) break block16;
                        NodeList nodes = root.getChildNodes();
                        Node node = null;
                        Element element = null;
                        int i = 0;
                        while (i < nodes.getLength()) {
                            node = nodes.item(i);
                            if (node.getNodeType() == 1 && (element = (Element)node).getNodeName().equalsIgnoreCase("entry")) {
                                String loc = element.getAttribute("loc");
                                String stamp = element.getAttribute("stamp");
                                try {
                                    Long l = Long.valueOf(stamp);
                                    fgInstallTimeMap.put(loc, l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
    }

    private static void writeInstallInfo() {
        if (!fgInstallTimeMap.isEmpty()) {
            try {
                Document doc = DebugPlugin.newDocument();
                Element root = doc.createElement("dirs");
                doc.appendChild(root);
                Map.Entry<String, Long> entry2 = null;
                Element e = null;
                String key = null;
                for (Map.Entry<String, Long> entry2 : fgInstallTimeMap.entrySet()) {
                    key = entry2.getKey();
                    if (!fgLibraryInfoMap.isEmpty() && !fgLibraryInfoMap.containsKey(key)) continue;
                    e = doc.createElement("entry");
                    root.appendChild(e);
                    e.setAttribute("loc", key);
                    e.setAttribute("stamp", entry2.getValue().toString());
                }
                String xml = DebugPlugin.serializeDocument((Document)doc);
                IPath libPath = LaunchingPlugin.getDefault().getStateLocation();
                File file = (libPath = libPath.append(".install.xml")).toFile();
                if (!file.exists()) {
                    file.createNewFile();
                }
                Throwable throwable = null;
                Object var9_11 = null;
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
                    ((OutputStream)stream).write(xml.getBytes(StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    private static String[] getPathsFromXML(Element lib, String pathType) {
        ArrayList<String> paths = new ArrayList<String>();
        NodeList list = lib.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            String nodeName;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase(pathType)) {
                NodeList entries = element.getChildNodes();
                int numEntries = entries.getLength();
                int j = 0;
                while (j < numEntries) {
                    String path;
                    Element entryElement;
                    String name;
                    Node n = entries.item(j);
                    short t = n.getNodeType();
                    if (t == 1 && (name = (entryElement = (Element)n).getNodeName()).equals("entry") && (path = entryElement.getAttribute("path")) != null && path.length() > 0) {
                        paths.add(path);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return paths.toArray(new String[paths.size()]);
    }

    public void launchesRemoved(ILaunch[] launches) {
        ArchiveSourceLocation.closeArchives();
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object source;
            DebugEvent event = events[i];
            if (event.getKind() == 8 && ((source = event.getSource()) instanceof IDebugTarget || source instanceof IProcess)) {
                ArchiveSourceLocation.closeArchives();
                IProcess process = source instanceof IProcess ? (IProcess)source : ((IDebugTarget)source).getProcess();
                if (process != null) {
                    this.deleteProcessTempFiles(process);
                }
            }
            ++i;
        }
    }

    private void deleteProcessTempFiles(IProcess process) {
        String tempFiles = process.getAttribute(ATTR_LAUNCH_TEMP_FILES);
        if (tempFiles == null) {
            return;
        }
        Arrays.stream(tempFiles.split(File.pathSeparator)).map(path -> new File((String)path)).filter(file -> this.isValidProcessTempFile((File)file)).forEach(file -> {
            boolean bl = file.delete();
        });
    }

    private boolean isValidProcessTempFile(File file) {
        return file.getName().startsWith(LAUNCH_TEMP_FILE_PREFIX);
    }

    public static DocumentBuilder getParser() throws CoreException {
        if (fgXMLParser == null) {
            try {
                DocumentBuilder p = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
                p.setErrorHandler(new DefaultHandler());
                fgXMLParser = p;
            }
            catch (FactoryConfigurationError | ParserConfigurationException e) {
                LaunchingPlugin.abort(LaunchingMessages.LaunchingPlugin_34, e);
            }
        }
        return fgXMLParser;
    }

    protected static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, message, exception);
        throw new CoreException((IStatus)status);
    }

    public static boolean sameURL(URL url1, URL url2) {
        if (url1 == url2) {
            return true;
        }
        if (url1 == null ^ url2 == null) {
            return false;
        }
        boolean isFile1 = "file".equalsIgnoreCase(url1.getProtocol());
        boolean isFile2 = "file".equalsIgnoreCase(url2.getProtocol());
        if (isFile1 && isFile2) {
            File file1 = new File(url1.getFile());
            File file2 = new File(url2.getFile());
            return file1.equals(file2);
        }
        if (isFile1 ^ isFile2) {
            return false;
        }
        return LaunchingPlugin.getExternalForm(url1).equals(LaunchingPlugin.getExternalForm(url2));
    }

    private static String getExternalForm(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm == null) {
            return EMPTY_STRING;
        }
        if ((externalForm = externalForm.trim()).endsWith("/")) {
            externalForm = externalForm.substring(0, externalForm.length() - 1);
        }
        return externalForm.toLowerCase();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String property = event.getKey();
        if (property.equals(JavaRuntime.PREF_VM_XML) && !this.isIgnoreVMDefPropertyChangeEvents()) {
            this.processVMPrefsChanged((String)event.getOldValue(), (String)event.getNewValue());
        }
    }

    public void optionsChanged(DebugOptions options) {
        DEBUG = options.getBooleanOption(DEBUG_FLAG, false);
        DEBUG_JRE_CONTAINER = DEBUG && options.getBooleanOption(DEBUG_JRE_CONTAINER_FLAG, false);
    }

    public static void trace(String option, String message, Throwable throwable) {
        System.out.println(message);
        if (fgDebugTrace != null) {
            fgDebugTrace.trace(option, message, throwable);
        }
    }

    public static void trace(String message) {
        LaunchingPlugin.trace(null, message, null);
    }

    class JREUpdateJob
    extends Job {
        private final VMChanges fChanges;

        public JREUpdateJob(VMChanges changes) {
            super(LaunchingMessages.LaunchingPlugin_1);
            this.fChanges = changes;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.fChanges.doit(monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }

    class VMChanges
    implements IVMInstallChangedListener {
        private volatile boolean fDefaultChanged;
        private final ConcurrentHashMap<IPath, IPath> fRenamedContainerIds = new ConcurrentHashMap();

        VMChanges() {
        }

        private IPath getContainerId(IVMInstall vm) {
            String name;
            if (vm != null && (name = vm.getName()) != null) {
                Path path = new Path(JavaRuntime.JRE_CONTAINER);
                path = path.append((IPath)new Path(vm.getVMInstallType().getId()));
                path = path.append((IPath)new Path(name));
                return path;
            }
            return null;
        }

        @Override
        public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
            this.fDefaultChanged = true;
        }

        @Override
        public void vmAdded(IVMInstall vm) {
        }

        @Override
        public void vmChanged(PropertyChangeEvent event) {
            String property = event.getProperty();
            IVMInstall vm = (IVMInstall)event.getSource();
            if (property.equals(IVMInstallChangedListener.PROPERTY_NAME)) {
                IPath newId = this.getContainerId(vm);
                Path oldId = new Path(JavaRuntime.JRE_CONTAINER);
                oldId = oldId.append(vm.getVMInstallType().getId());
                String oldName = (String)event.getOldValue();
                if (oldName != null) {
                    oldId = oldId.append(oldName);
                    this.fRenamedContainerIds.put((IPath)oldId, newId);
                    try {
                        ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                        String container = null;
                        ILaunchConfigurationWorkingCopy wc = null;
                        Path cpath = null;
                        int i = 0;
                        while (i < configs.length) {
                            container = configs[i].getAttribute(JavaRuntime.JRE_CONTAINER, null);
                            if (container != null && (cpath = new Path(container)).lastSegment().equals(oldName)) {
                                cpath = cpath.removeLastSegments(1).append(newId.lastSegment()).addTrailingSeparator();
                                wc = configs[i].getWorkingCopy();
                                wc.setAttribute(JavaRuntime.JRE_CONTAINER, cpath.toString());
                                wc.doSave();
                            }
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void vmRemoved(IVMInstall vm) {
        }

        public void process() {
            JREUpdateJob job = new JREUpdateJob(this);
            job.schedule();
        }

        protected void doit(IProgressMonitor monitor) throws CoreException {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor1) throws CoreException {
                    IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                    monitor1.beginTask(LaunchingMessages.LaunchingPlugin_0, projects.length + 1);
                    VMChanges.this.rebind(monitor1, projects);
                    monitor1.done();
                }
            };
            JavaCore.run((IWorkspaceRunnable)runnable, null, (IProgressMonitor)monitor);
        }

        private void rebind(IProgressMonitor monitor, IJavaProject[] projects) throws CoreException {
            if (this.fDefaultChanged) {
                JavaClasspathVariablesInitializer initializer = new JavaClasspathVariablesInitializer();
                initializer.initialize("JRE_LIB");
                initializer.initialize("JRE_SRC");
                initializer.initialize("JRE_SRCROOT");
            }
            monitor.worked(1);
            int length = projects.length;
            HashMap<IPath, ArrayList<IJavaProject>> projectsMap = new HashMap<IPath, ArrayList<IJavaProject>>();
            int i = 0;
            while (i < length) {
                IJavaProject project = projects[i];
                IClasspathEntry[] entries = project.getRawClasspath();
                boolean replace = false;
                int j = 0;
                while (j < entries.length) {
                    IClasspathEntry entry = entries[j];
                    switch (entry.getEntryKind()) {
                        case 5: {
                            IClasspathEntry newEntry;
                            IPath renamed;
                            IPath reference = entry.getPath();
                            IPath newBinding = null;
                            String firstSegment = reference.segment(0);
                            if (!JavaRuntime.JRE_CONTAINER.equals(firstSegment)) break;
                            if (reference.segmentCount() > 1 && (renamed = this.fRenamedContainerIds.get(reference)) != null) {
                                newBinding = renamed;
                            }
                            if (newBinding == null) {
                                ArrayList<IJavaProject> projectsList = (ArrayList<IJavaProject>)projectsMap.get(reference);
                                if (projectsList == null) {
                                    projectsList = new ArrayList<IJavaProject>(length);
                                    projectsMap.put(reference, projectsList);
                                }
                                projectsList.add(project);
                                break;
                            }
                            entries[j] = newEntry = JavaCore.newContainerEntry(newBinding, (boolean)entry.isExported());
                            replace = true;
                            break;
                        }
                    }
                    ++j;
                }
                if (replace) {
                    project.setRawClasspath(entries, null);
                }
                monitor.worked(1);
                ++i;
            }
            for (IPath reference : projectsMap.keySet()) {
                List projectsList = (List)projectsMap.get(reference);
                IJavaProject[] referenceProjects = new IJavaProject[projectsList.size()];
                projectsList.toArray(referenceProjects);
                JREContainerInitializer initializer = new JREContainerInitializer();
                initializer.initialize(reference, referenceProjects);
            }
        }
    }
}

