/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XtextGeneratorResourceSetInitializer {
    private static final Logger LOG = Logger.getLogger(XtextGeneratorResourceSetInitializer.class);

    public void initialize(ResourceSet resourceSet, List<String> referencedResources) {
        StandaloneSetup delegate = new StandaloneSetup();
        delegate.setResourceSet(resourceSet);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        referencedResources.forEach(it -> this.loadResource((String)it, resourceSet));
        this.registerGenModels(resourceSet);
        this.registerEPackages(resourceSet);
    }

    private void loadResource(String loadedResource, ResourceSet resourceSet) {
        URI loadedResourceUri = URI.createURI((String)loadedResource);
        this.ensureResourceCanBeLoaded(loadedResourceUri, resourceSet);
        resourceSet.getResource(loadedResourceUri, true);
    }

    private void ensureResourceCanBeLoaded(URI loadedResource, ResourceSet resourceSet) {
        block27: {
            String fileExtension = loadedResource.fileExtension();
            if (fileExtension == null) break block27;
            switch (fileExtension) {
                case "genmodel": {
                    GenModelPackage.eINSTANCE.getEFactoryInstance();
                    IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
                    if (resourceServiceProvider == null) {
                        try {
                            Class<?> genModelSupport = Class.forName("org.eclipse.emf.codegen.ecore.xtext.GenModelSupport");
                            Object instance = genModelSupport.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            genModelSupport.getDeclaredMethod("createInjectorAndDoEMFRegistration", new Class[0]).invoke(instance, new Object[0]);
                        }
                        catch (ClassNotFoundException e) {
                            LOG.debug((Object)"org.eclipse.emf.codegen.ecore.xtext.GenModelSupport not found, GenModels will not be indexed");
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Couldn't initialize GenModel support.", (Throwable)e);
                        }
                    }
                    return;
                }
                case "ecore": {
                    IResourceServiceProvider resourceServiceProvider2 = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
                    if (resourceServiceProvider2 == null) {
                        try {
                            Class<?> ecore = Class.forName("org.eclipse.xtext.ecore.EcoreSupportStandaloneSetup");
                            ecore.getDeclaredMethod("setup", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (ClassNotFoundException e) {
                            LOG.error((Object)"Couldn't initialize Ecore support. Is 'org.eclipse.xtext.ecore' on the classpath?");
                            LOG.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Couldn't initialize Ecore support.", (Throwable)e);
                        }
                    }
                    return;
                }
                case "xcore": {
                    IResourceServiceProvider resourceServiceProvider3 = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
                    if (resourceServiceProvider3 == null) {
                        try {
                            Class<?> xcore = Class.forName("org.eclipse.emf.ecore.xcore.XcoreStandaloneSetup");
                            xcore.getDeclaredMethod("doSetup", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (ClassNotFoundException e) {
                            LOG.error((Object)"Couldn't initialize Xcore support. Is it on the classpath?");
                            LOG.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Couldn't initialize Xcore support.", (Throwable)e);
                        }
                    }
                    URI xcoreLangURI = URI.createPlatformResourceURI((String)"/org.eclipse.emf.ecore.xcore.lib/model/XcoreLang.xcore", (boolean)true);
                    try {
                        resourceSet.getResource(xcoreLangURI, true);
                    }
                    catch (WrappedException e) {
                        LOG.error((Object)"Could not load XcoreLang.xcore.", (Throwable)e);
                        Resource brokenResource = resourceSet.getResource(xcoreLangURI, false);
                        resourceSet.getResources().remove((Object)brokenResource);
                    }
                    return;
                }
            }
        }
    }

    private void registerEPackages(ResourceSet resourceSet) {
        this.each(resourceSet, EPackage.class, it -> this.register((EPackage)it));
    }

    private void register(EPackage ePackage) {
        EPackage.Registry registry = ePackage.eResource().getResourceSet().getPackageRegistry();
        Object existing = registry.get((Object)ePackage.getNsURI());
        if (existing == null) {
            registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
    }

    private void registerGenModels(ResourceSet resourceSet) {
        this.each(resourceSet, GenModel.class, it -> this.register((GenModel)it));
    }

    private void register(GenModel genModel) {
        new GenModelHelper().registerGenModel(genModel);
    }

    private <Type> void each(ResourceSet resourceSet, Class<Type> type, Procedures.Procedure1<? super Type> strategy) {
        int i = 0;
        while (i < resourceSet.getResources().size()) {
            Resource resource = (Resource)resourceSet.getResources().get(i);
            Iterables.filter((Iterable)resource.getContents(), type).forEach(it -> strategy.apply(it));
            ++i;
        }
    }
}

