/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class SimpleObjectTransfer
extends ByteArrayTransfer {
    private Object object;
    private long startTime;

    public Object getObject() {
        return this.object;
    }

    public void javaToNative(Object object, TransferData transferData) {
        this.setObject(object);
        this.startTime = System.currentTimeMillis();
        if (transferData != null) {
            super.javaToNative((Object)String.valueOf(this.startTime).getBytes(), transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        long startTime = Long.parseLong(new String(bytes));
        return this.startTime == startTime ? this.getObject() : null;
    }

    public void setObject(Object obj) {
        this.object = obj;
    }
}

