/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.actions;

import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.CurrentNodeSelectionTransformer;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Perspective;

public abstract class Action {
    protected Controller controller_;
    protected Hashtable propertyTable_;
    protected Vector removedProperties_;

    public Action() {
        this(null);
    }

    public Action(Controller controller) {
        this.controller_ = controller;
        this.propertyTable_ = new Hashtable();
        this.removedProperties_ = new Vector();
    }

    public final Controller getController() {
        return this.controller_;
    }

    public abstract boolean populatePropertyTable(HttpServletRequest var1);

    public final Hashtable getPropertyTable() {
        return this.propertyTable_;
    }

    public void setPropertyTable(Hashtable propertyTable) {
        this.propertyTable_ = propertyTable;
    }

    public final void addProperty(Object key, Object value) {
        this.propertyTable_.put(key, value);
    }

    public final void removeProperty(Object key) {
        this.propertyTable_.remove(key);
        this.removedProperties_.addElement(key);
    }

    public final String[] getPropertyAsStringArray(Object key) {
        Object object = this.propertyTable_.get(key);
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object != null) {
            return new String[]{object.toString()};
        }
        return new String[0];
    }

    public final boolean execute() {
        return this.execute(true);
    }

    public final boolean execute(boolean useActionEngine) {
        if (useActionEngine) {
            return this.controller_.getActionEngine().executeAction(this);
        }
        return this.run();
    }

    public abstract boolean run();

    public ITransformer[] getTransformers() {
        return new ITransformer[]{new CurrentNodeSelectionTransformer(this.controller_)};
    }

    protected void handleUnexpectedException(Perspective perspective, MessageQueue messageQueue, String exceptionName, Throwable t) {
        messageQueue.addMessage(perspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
        messageQueue.addMessage(exceptionName);
        messageQueue.addMessage(t.getMessage());
    }
}

