/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class Translation
implements ITranslation {
    private String m_key;
    private final Map<Language, String> m_texts;

    public Translation(ITranslation template) {
        this.m_key = (String)Ensure.notNull((Object)template.key());
        this.m_texts = new TreeMap<Language, String>(template.texts());
    }

    public Translation(String key) {
        this.m_key = (String)Ensure.notNull((Object)key);
        this.m_texts = new TreeMap<Language, String>();
    }

    protected Map<Language, String> textsMap() {
        return this.m_texts;
    }

    public void putText(Language lang, String text) {
        if (Strings.isEmpty((CharSequence)text)) {
            this.textsMap().remove(Ensure.notNull((Object)lang));
        } else {
            this.textsMap().put((Language)Ensure.notNull((Object)lang), text);
        }
    }

    @Override
    public Translation merged(ITranslation translation) {
        Translation merged = new Translation(this);
        if (translation != null) {
            translation.texts().forEach(merged::putText);
        }
        return merged;
    }

    public void setKey(String newKey) {
        this.m_key = (String)Ensure.notNull((Object)newKey);
    }

    @Override
    public String key() {
        return this.m_key;
    }

    @Override
    public Optional<String> text(Language language) {
        return Optional.ofNullable(this.textsMap().get(Ensure.notNull((Object)language)));
    }

    @Override
    public Optional<String> bestText(Language language) {
        if (language == null) {
            return this.text(Language.LANGUAGE_DEFAULT);
        }
        Map availableLocales = this.textsMap().keySet().stream().collect(Collectors.toMap(Language::locale, Function.identity()));
        Locale.LanguageRange range = new Locale.LanguageRange(language.locale().toLanguageTag(), 1.0);
        Locale result = Locale.lookup(Collections.singletonList(range), availableLocales.keySet());
        return Optional.ofNullable(result).map(availableLocales::get).flatMap(this::text).or(() -> this.text(Language.LANGUAGE_DEFAULT));
    }

    @Override
    public Map<Language, String> texts() {
        return Collections.unmodifiableMap(this.textsMap());
    }

    @Override
    public Stream<Language> languages() {
        return this.textsMap().keySet().stream();
    }

    public int hashCode() {
        return 31 * this.key().hashCode() + this.textsMap().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Translation other = (Translation)obj;
        return this.key().equals(other.key()) && this.textsMap().equals(other.textsMap());
    }

    public String toString() {
        return this.key() + "=" + String.valueOf(this.textsMap());
    }
}

