/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.query;

import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.spliterator.InnerTypeSpliterator;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;

public abstract class AbstractInnerTypeQuery<T extends AbstractInnerTypeQuery<T>>
extends AbstractQuery<IType>
implements Predicate<IType> {
    private final Spliterator<IType> m_innerTypes;
    private final T m_thisInstance;
    private boolean m_includeRecursiveInnerTypes;
    private ApiFunction<?, ITypeNameSupplier> m_name;
    private ApiFunction<?, ITypeNameSupplier> m_simpleName;
    private ApiFunction<?, ITypeNameSupplier> m_instanceOf;
    private int m_flags = -1;

    protected AbstractInnerTypeQuery(Spliterator<IType> innerTypes) {
        this.m_innerTypes = innerTypes;
        this.m_thisInstance = this;
    }

    protected Spliterator<IType> getInnerTypeSpliterator() {
        return this.m_innerTypes;
    }

    public T withRecursiveInnerTypes(boolean b) {
        this.m_includeRecursiveInnerTypes = b;
        return this.m_thisInstance;
    }

    protected boolean isIncludeRecursiveInnerTypes() {
        return this.m_includeRecursiveInnerTypes;
    }

    public T withFlags(int flags) {
        this.m_flags = flags;
        return this.m_thisInstance;
    }

    protected int getFlags() {
        return this.m_flags;
    }

    public T withName(CharSequence fullyQualifiedName) {
        ITypeNameSupplier supplier = ITypeNameSupplier.of(fullyQualifiedName);
        return this.withNameFrom(null, api -> supplier);
    }

    public <API extends IApiSpecification> T withNameFrom(Class<API> api, Function<API, ITypeNameSupplier> nameFunction) {
        this.m_name = nameFunction == null ? null : new ApiFunction<API, ITypeNameSupplier>(api, nameFunction);
        return this.m_thisInstance;
    }

    protected ApiFunction<?, ITypeNameSupplier> getName() {
        return this.m_name;
    }

    public T withSimpleName(CharSequence simpleName) {
        ITypeNameSupplier supplier = ITypeNameSupplier.of(simpleName);
        return this.withSimpleNameFrom(null, api -> supplier);
    }

    public <API extends IApiSpecification> T withSimpleNameFrom(Class<API> api, Function<API, ITypeNameSupplier> simpleNameFunction) {
        this.m_simpleName = simpleNameFunction == null ? null : new ApiFunction<API, ITypeNameSupplier>(api, simpleNameFunction);
        return this.m_thisInstance;
    }

    protected ApiFunction<?, ITypeNameSupplier> getSimpleName() {
        return this.m_simpleName;
    }

    public T withInstanceOf(CharSequence typeFqn) {
        return this.withInstanceOf(ITypeNameSupplier.of(typeFqn));
    }

    public T withInstanceOf(ITypeNameSupplier typeFqnSupplier) {
        return this.withInstanceOfFrom(null, api -> typeFqnSupplier);
    }

    public <API extends IApiSpecification> T withInstanceOfFrom(Class<API> api, Function<API, ITypeNameSupplier> nameFunction) {
        this.m_instanceOf = nameFunction == null ? null : new ApiFunction<API, ITypeNameSupplier>(api, nameFunction);
        return this.m_thisInstance;
    }

    protected ApiFunction<?, ITypeNameSupplier> getInstanceOf() {
        return this.m_instanceOf;
    }

    @Override
    public boolean test(IType t) {
        IJavaEnvironment context = t.javaEnvironment();
        int flags = this.getFlags();
        if (flags >= 0 && (t.flags() & flags) != flags) {
            return false;
        }
        ITypeNameSupplier instanceOf = Optional.ofNullable(this.getInstanceOf()).flatMap(nameFilter -> nameFilter.apply(context)).orElse(null);
        if (instanceOf != null && !t.isInstanceOf(instanceOf)) {
            return false;
        }
        String name = Optional.ofNullable(this.getName()).flatMap(nameFilter -> nameFilter.apply(context)).map(ITypeNameSupplier::fqn).orElse(null);
        if (name != null && !name.equals(t.name())) {
            return false;
        }
        String simpleName = Optional.ofNullable(this.getSimpleName()).flatMap(simpleNameFilter -> simpleNameFilter.apply(context)).map(ITypeNameSupplier::simpleName).orElse(null);
        return simpleName == null || simpleName.equals(t.elementName());
    }

    public Stream<IType> stream() {
        return super.stream().filter(this);
    }

    protected Stream<IType> createStream() {
        return StreamSupport.stream(new InnerTypeSpliterator(this.getInnerTypeSpliterator(), this.isIncludeRecursiveInnerTypes()), false);
    }
}

