/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.extensions.generators.AttributeDeclaration;
import org.eclipse.lemminx.extensions.generators.ChildrenProperties;
import org.eclipse.lemminx.extensions.generators.ContainerDeclaration;

public class ElementDeclaration
extends ContainerDeclaration {
    private final String name;
    private ElementDeclaration parent;
    private final Map<String, AttributeDeclaration> attributes;
    private boolean hasCharacterContent;
    private ChildrenProperties childrenProperties;
    private int occurrences;
    private boolean hasAttributeId;

    public ElementDeclaration(String name) {
        this.name = name;
        this.attributes = new LinkedHashMap<String, AttributeDeclaration>();
        this.childrenProperties = new ChildrenProperties();
        this.setHasCharacterContent(false);
        this.occurrences = 0;
    }

    public String getName() {
        return this.name;
    }

    public AttributeDeclaration getAttribute(String name) {
        AttributeDeclaration attribute = this.attributes.get(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = new AttributeDeclaration(name, this);
        this.attributes.put(name, attribute);
        return attribute;
    }

    public Collection<AttributeDeclaration> getAttributes() {
        return this.attributes.values();
    }

    public boolean hasCharacterContent() {
        return this.hasCharacterContent;
    }

    void setHasCharacterContent(boolean hasCharacterContent) {
        this.hasCharacterContent = hasCharacterContent;
    }

    @Override
    public void addElement(ElementDeclaration element) {
        super.addElement(element);
        element.setParent(this);
    }

    public ElementDeclaration getParent() {
        return this.parent;
    }

    void setParent(ElementDeclaration parent) {
        this.parent = parent;
    }

    public void addChildHierarchy(List<String> tags) {
        this.childrenProperties.addChildHierarchy(tags);
    }

    public ChildrenProperties getChildrenProperties() {
        return this.childrenProperties;
    }

    public void incrementOccurrences() {
        ++this.occurrences;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public boolean hasAttributeId() {
        return this.hasAttributeId;
    }

    void setAttributeID(boolean doneID) {
        this.hasAttributeId = doneID;
    }
}

