/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.editor;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.wst.xsd.ui.internal.adt.editor.IADTEditorInput;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.xsd.XSDSchema;

public class ADTFileStoreEditorInput
extends FileStoreEditorInput
implements IADTEditorInput {
    private XSDSchema schema;
    private String editorName;

    public ADTFileStoreEditorInput(IFileStore fileStore, XSDSchema xsdSchema) {
        super(fileStore);
        this.schema = xsdSchema;
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public void setEditorName(String name) {
        this.editorName = name;
    }

    public String getName() {
        if (this.editorName != null) {
            return this.editorName;
        }
        return super.getName();
    }

    public String getToolTipText() {
        if (this.schema != null) {
            String ns = this.schema.getTargetNamespace();
            if (ns != null && ns.length() > 0) {
                return String.valueOf(Messages._UI_LABEL_TARGET_NAMESPACE) + ns;
            }
            return Messages._UI_LABEL_NO_NAMESPACE;
        }
        return super.getToolTipText();
    }
}

