/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public class DocumentProviderRegistry {
    private static DocumentProviderRegistry fgRegistry;
    private final Map<String, Set<IConfigurationElement>> fExtensionMapping = new HashMap<String, Set<IConfigurationElement>>();
    private final Map<String, Set<IConfigurationElement>> fInputTypeMapping = new HashMap<String, Set<IConfigurationElement>>();
    private final Map<IConfigurationElement, IDocumentProvider> fInstances = new HashMap<IConfigurationElement, IDocumentProvider>();

    public static DocumentProviderRegistry getDefault() {
        if (fgRegistry == null) {
            fgRegistry = new DocumentProviderRegistry();
        }
        return fgRegistry;
    }

    private DocumentProviderRegistry() {
        this.initialize();
    }

    private void read(Map<String, Set<IConfigurationElement>> map, IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                Set<IConfigurationElement> s = map.get(token);
                if (s == null) {
                    s = new HashSet<IConfigurationElement>();
                    map.put(token, s);
                }
                s.add(element);
            }
        }
    }

    private void initialize() {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "documentProviders");
        if (extensionPoint == null) {
            String msg = NLSUtility.format(TextEditorMessages.DocumentProviderRegistry_error_extension_point_not_found, "org.eclipse.ui");
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog log = ILog.of((Bundle)bundle);
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.read(this.fExtensionMapping, element, "extensions");
            this.read(this.fInputTypeMapping, element, "inputTypes");
            ++n2;
        }
    }

    private IDocumentProvider getDocumentProvider(IConfigurationElement entry) {
        IDocumentProvider provider = this.fInstances.get(entry);
        if (provider == null) {
            try {
                provider = (IDocumentProvider)entry.createExecutableExtension("class");
                this.fInstances.put(entry, provider);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return provider;
    }

    private IConfigurationElement selectConfigurationElement(Set<IConfigurationElement> set) {
        if (set != null && !set.isEmpty()) {
            Iterator<IConfigurationElement> e = set.iterator();
            return e.next();
        }
        return null;
    }

    public IDocumentProvider getDocumentProvider(String extension) {
        Set<IConfigurationElement> set = this.fExtensionMapping.get(extension);
        if (set != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            return this.getDocumentProvider(entry);
        }
        return null;
    }

    private List<Class<?>> computeClassList(Class<?> type) {
        ArrayList result = new ArrayList();
        Class<?> c = type;
        while (c != null) {
            result.add(c);
            c = c.getSuperclass();
        }
        return result;
    }

    private List<Class<?>> computeInterfaceList(List<Class<?>> classes) {
        ArrayList result = new ArrayList(4);
        Hashtable visited = new Hashtable(4);
        for (Class<?> c : classes) {
            this.computeInterfaceList(c.getInterfaces(), result, visited);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void computeInterfaceList(Class<?>[] interfaces, List<Class<?>> result, Hashtable<Class<?>, Class<?>> visited) {
        void var6_8;
        ArrayList toBeVisited = new ArrayList(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        boolean n2 = false;
        while (var6_8 < n) {
            Class<?> iface = classArray[var6_8];
            if (visited.get(iface) == null) {
                visited.put(iface, iface);
                result.add(iface);
                toBeVisited.add(iface);
            }
            ++var6_8;
        }
        for (Class clazz : toBeVisited) {
            this.computeInterfaceList(clazz.getInterfaces(), result, visited);
        }
    }

    private Set<IConfigurationElement> getFirstInputTypeMapping(List<Class<?>> classes) {
        for (Class<?> c : classes) {
            Set<IConfigurationElement> mapping = this.fInputTypeMapping.get(c.getName());
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }

    private Set<IConfigurationElement> findInputTypeMapping(Class<?> type) {
        if (type == null) {
            return null;
        }
        Set<IConfigurationElement> mapping = this.fInputTypeMapping.get(type.getName());
        if (mapping != null) {
            return mapping;
        }
        List<Class<?>> classList = this.computeClassList(type);
        mapping = this.getFirstInputTypeMapping(classList);
        if (mapping != null) {
            return mapping;
        }
        return this.getFirstInputTypeMapping(this.computeInterfaceList(classList));
    }

    public IDocumentProvider getDocumentProvider(IEditorInput editorInput) {
        Set<IConfigurationElement> set;
        IDocumentProvider provider = null;
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file != null) {
            provider = this.getDocumentProvider(file.getFileExtension());
        } else {
            IPath path;
            IPathEditorInput pathInput = (IPathEditorInput)Adapters.adapt((Object)editorInput, IPathEditorInput.class);
            if (pathInput != null && (path = pathInput.getPath()) != null) {
                provider = this.getDocumentProvider(path.getFileExtension());
            }
        }
        if (provider == null && (set = this.findInputTypeMapping(editorInput.getClass())) != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            provider = this.getDocumentProvider(entry);
        }
        return provider;
    }
}

