/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocationHint;
import org.eclipse.lemminx.dom.XMLModel;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPSAXParser;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPoolWrapper;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLParserConfiguration;
import org.eclipse.lemminx.extensions.contentmodel.settings.NamespacesEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.SchemaEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLNamespacesSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLSchemaSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.xerces.LSPXMLEntityManager;
import org.eclipse.lemminx.extensions.xerces.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.services.extensions.diagnostics.LSPContentHandler;
import org.eclipse.lemminx.uriresolver.CacheResourceException;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLValidator {
    private static final Logger LOGGER = Logger.getLogger(XMLValidator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, ContentModelManager contentModelManager, CancelChecker monitor) {
        LSPXMLGrammarPool pool = contentModelManager.getGrammarPool();
        LSPXMLGrammarPoolWrapper grammarPool = pool != null ? new LSPXMLGrammarPoolWrapper(pool) : null;
        HashMap<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache = new HashMap<String, ReferencedGrammarDiagnosticsInfo>();
        LSPErrorReporterForXML reporterForXML = new LSPErrorReporterForXML(document, diagnostics, contentModelManager, validationSettings != null ? validationSettings.isRelatedInformation() : false, referencedGrammarDiagnosticsInfoCache);
        LSPErrorReporterForXML reporterForGrammar = new LSPErrorReporterForXML(document, diagnostics, contentModelManager, validationSettings != null ? validationSettings.isRelatedInformation() : false, referencedGrammarDiagnosticsInfoCache);
        LSPXMLEntityManager entityManager = new LSPXMLEntityManager(reporterForXML, grammarPool);
        try {
            boolean hasGrammar;
            LSPXMLParserConfiguration configuration = new LSPXMLParserConfiguration(grammarPool, XMLValidator.isDisableOnlyDTDValidation(document), reporterForXML, reporterForGrammar, entityManager, validationSettings);
            if (entityResolver != null) {
                configuration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", entityResolver);
            }
            LSPSAXParser parser = new LSPSAXParser(reporterForXML, configuration, grammarPool, document);
            ((AbstractSAXParser)parser).setContentHandler(new LSPContentHandler(monitor));
            XMLValidator.warnNoGrammar(document, diagnostics, validationSettings);
            XMLValidator.updateExternalGrammarLocation(document, parser);
            boolean hasSchemaLocation = document.hasSchemaLocation();
            boolean hasNoNamespaceSchemaLocation = document.hasNoNamespaceSchemaLocation();
            boolean hasSchemaGrammar = hasSchemaLocation || hasNoNamespaceSchemaLocation || XMLValidator.hasExternalSchemaGrammar(document);
            boolean schemaValidationEnabled = hasSchemaGrammar && XMLValidator.isSchemaValidationEnabled(document, validationSettings) || hasNoNamespaceSchemaLocation && XMLValidator.isNoNamespaceSchemaValidationEnabled(document, validationSettings);
            parser.setFeature("http://apache.org/xml/features/validation/schema", schemaValidationEnabled);
            boolean hasRelaxNG = XMLValidator.hasRelaxNGReference(document, parser);
            boolean bl = hasGrammar = document.hasDTD() || hasSchemaGrammar || !hasRelaxNG && document.hasExternalGrammar();
            if (hasSchemaGrammar && !schemaValidationEnabled) {
                hasGrammar = false;
            }
            parser.setFeature("http://xml.org/sax/features/validation", hasGrammar);
            boolean namespacesValidationEnabled = XMLValidator.isNamespacesValidationEnabled(document, validationSettings, hasRelaxNG);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", namespacesValidationEnabled);
            InputSource input = DOMUtils.createInputSource(document);
            parser.parse(input);
        }
        catch (IOException | CancellationException | SAXException configuration) {
        }
        catch (CacheResourceException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected XMLValidator error", e);
        }
        finally {
            reporterForXML.endReport();
            reporterForGrammar.endReport();
            entityManager.dispose();
        }
    }

    private static boolean isNamespacesValidationEnabled(DOMDocument document, XMLValidationSettings validationSettings, boolean hasRelaxNG) {
        if (hasRelaxNG) {
            return true;
        }
        if (validationSettings == null) {
            return true;
        }
        NamespacesEnabled enabled = NamespacesEnabled.always;
        XMLNamespacesSettings namespacesSettings = validationSettings.getNamespaces();
        if (namespacesSettings != null && namespacesSettings.getEnabled() != null) {
            enabled = namespacesSettings.getEnabled();
        }
        switch (enabled) {
            case always: {
                return true;
            }
            case never: {
                return false;
            }
            case onNamespaceEncountered: {
                return document.hasNamespaces();
            }
        }
        return true;
    }

    private static boolean hasRelaxNGReference(DOMDocument document, SAXParser parser) {
        try {
            if (parser.getProperty("http://apache.org/xml/properties/relaxng/external-relaxng") != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<XMLModel> models = document.getXMLModels();
        for (XMLModel xmlModel : models) {
            if (!DOMUtils.isRelaxNGUri(xmlModel.getHref())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSchemaValidationEnabled(DOMDocument document, XMLValidationSettings validationSettings) {
        if (validationSettings == null) {
            return true;
        }
        SchemaEnabled enabled = SchemaEnabled.always;
        XMLSchemaSettings schemaSettings = validationSettings.getSchema();
        if (schemaSettings != null && schemaSettings.getEnabled() != null) {
            enabled = schemaSettings.getEnabled();
        }
        switch (enabled) {
            case always: {
                return true;
            }
            case never: {
                return false;
            }
            case onValidSchema: {
                return XMLValidator.isValidSchemaLocation(document);
            }
        }
        return true;
    }

    private static boolean isValidSchemaLocation(DOMDocument document) {
        if (!document.hasSchemaLocation()) {
            return false;
        }
        String namespaceURI = document.getNamespaceURI();
        SchemaLocationHint hint = document.getSchemaLocation().getLocationHint(namespaceURI);
        if (hint == null) {
            return false;
        }
        String location = hint.getHint();
        return XMLValidator.isValidLocation(document.getDocumentURI(), location);
    }

    private static boolean isNoNamespaceSchemaValidationEnabled(DOMDocument document, XMLValidationSettings validationSettings) {
        if (validationSettings == null) {
            return true;
        }
        SchemaEnabled enabled = SchemaEnabled.always;
        XMLSchemaSettings schemaSettings = validationSettings.getSchema();
        if (schemaSettings != null && schemaSettings.getEnabled() != null) {
            enabled = schemaSettings.getEnabled();
        }
        switch (enabled) {
            case always: {
                return true;
            }
            case never: {
                return false;
            }
            case onValidSchema: {
                return XMLValidator.isValidNoNamespaceSchemaLocation(document);
            }
        }
        return true;
    }

    private static boolean isValidNoNamespaceSchemaLocation(DOMDocument document) {
        NoNamespaceSchemaLocation noNamespaceSchemaLocation = document.getNoNamespaceSchemaLocation();
        if (noNamespaceSchemaLocation == null) {
            return false;
        }
        String location = noNamespaceSchemaLocation.getLocation();
        return XMLValidator.isValidLocation(document.getDocumentURI(), location);
    }

    private static boolean isValidLocation(String documentURI, String location) {
        boolean bl;
        block9: {
            String resolvedLocation = XMLValidator.getResolvedLocation(documentURI, location);
            if (resolvedLocation == null) {
                return false;
            }
            InputStream is = new URL(resolvedLocation).openStream();
            try {
                bl = true;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (StringUtils.isBlank(location)) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId(location, documentURI, false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }

    private static boolean hasExternalSchemaGrammar(DOMDocument document) {
        if (DOMUtils.isXSD(document.getExternalGrammarFromNamespaceURI())) {
            return true;
        }
        Map<String, String> externalGrammarLocation = document.getExternalGrammarLocation();
        if (externalGrammarLocation == null) {
            return false;
        }
        return externalGrammarLocation.containsKey("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation") || externalGrammarLocation.containsKey("http://apache.org/xml/properties/schema/external-schemaLocation");
    }

    private static boolean isDisableOnlyDTDValidation(DOMDocument document) {
        Map<String, String> externalGrammarLocation = document.getExternalGrammarLocation();
        if (externalGrammarLocation != null && externalGrammarLocation.containsKey("http://apache.org/xml/properties/dtd/external-doctype")) {
            return true;
        }
        if (!document.hasDTD()) {
            return true;
        }
        DOMDocumentType docType = document.getDoctype();
        if (docType.getKindNode() != null) {
            return false;
        }
        return !docType.getChildren().stream().anyMatch(node -> node.isDTDElementDecl() || node.isDTDAttListDecl());
    }

    private static void warnNoGrammar(DOMDocument document, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings) {
        boolean hasGrammar = document.hasGrammar();
        if (hasGrammar) {
            return;
        }
        if (DOMUtils.isRelaxNG(document)) {
            return;
        }
        DiagnosticSeverity severity = XMLValidationSettings.getNoGrammarSeverity(validationSettings);
        if (severity == null) {
            return;
        }
        if (!hasGrammar) {
            Range range = null;
            DOMElement documentElement = document.getDocumentElement();
            if (documentElement != null) {
                range = XMLPositionUtility.selectStartTagName(documentElement);
            }
            if (range == null) {
                range = new Range(new Position(0, 0), new Position(0, 0));
            }
            diagnostics.add(new Diagnostic(range, "No grammar constraints (DTD or XML Schema).", severity, "xml", XMLSyntaxErrorCode.NoGrammarConstraints.name()));
        }
    }

    private static void updateExternalGrammarLocation(DOMDocument document, SAXParser reader) throws SAXNotRecognizedException, SAXNotSupportedException {
        String relaxng = null;
        Map<String, String> externalGrammarLocation = document.getExternalGrammarLocation();
        if (externalGrammarLocation != null) {
            String xsd = externalGrammarLocation.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
            if (xsd != null) {
                String defaultNamespace = null;
                DOMElement documentElement = document.getDocumentElement();
                if (documentElement != null) {
                    defaultNamespace = documentElement.getAttribute("xmlns");
                }
                if (StringUtils.isEmpty(defaultNamespace)) {
                    String noNamespaceSchemaLocation = xsd;
                    reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", noNamespaceSchemaLocation);
                } else {
                    String schemaLocation = defaultNamespace + " " + xsd;
                    reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemaLocation);
                }
            } else {
                String doctype = externalGrammarLocation.get("http://apache.org/xml/properties/dtd/external-doctype");
                if (doctype != null) {
                    reader.setProperty("http://apache.org/xml/properties/dtd/external-doctype", doctype);
                } else {
                    relaxng = externalGrammarLocation.get("http://apache.org/xml/properties/relaxng/external-relaxng");
                }
            }
        }
        if (relaxng == null) {
            String string = relaxng = DOMUtils.isRelaxNGUri(document.getExternalGrammarFromNamespaceURI()) ? document.getExternalGrammarFromNamespaceURI() : null;
        }
        if (relaxng != null) {
            reader.setProperty("http://apache.org/xml/properties/relaxng/external-relaxng", relaxng);
        }
    }
}

