/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.StateEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.ExecutionSelectionEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractNodeEventResizeSelectionValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;

public class StateSelectionEditPolicy
extends ExecutionSelectionEditPolicy {
    @Override
    protected Command getResizeCommand(ChangeBoundsRequest request) {
        this.updateHorizontalResize(request);
        return super.getResizeCommand(request);
    }

    @Override
    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.eraseChangeBoundsFeedback(request);
        StateEditPart hostPart = (StateEditPart)this.getHost();
        AbstractNodeEvent host = (AbstractNodeEvent)hostPart.getISequenceEvent();
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (requestQuery.isResize()) {
            this.updateHorizontalResize(request);
            this.customiseFeedbackFigure(request);
            AbstractNodeEventResizeSelectionValidator validator = AbstractNodeEventResizeSelectionValidator.getOrCreateValidator(request, host);
            validator.validate();
            this.showResizeFeedBack(request);
            this.feedBack(validator);
        } else {
            super.showChangeBoundsFeedback(request);
        }
    }

    private void customiseFeedbackFigure(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        Rectangle rect = this.getInitialFeedbackBounds().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        this.getHostFigure().translateToRelative((Translatable)rect);
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds(rect);
    }

    private void updateHorizontalResize(ChangeBoundsRequest request) {
        Point moveDelta = new Point(request.getMoveDelta());
        Dimension sizeDelta = new Dimension(request.getSizeDelta());
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (requestQuery.isResize()) {
            if (moveDelta.x == 0 && sizeDelta.width != 0) {
                moveDelta.setX(-sizeDelta.width);
            }
            if (sizeDelta.width == 0 && moveDelta.x != 0) {
                sizeDelta.setWidth(-moveDelta.x);
            }
            if (moveDelta.x == -sizeDelta.width) {
                sizeDelta.setWidth(sizeDelta.width - moveDelta.x);
            }
            request.setMoveDelta(moveDelta);
            request.setSizeDelta(sizeDelta);
        }
    }
}

