/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOModelEditorOpener;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorInput2;
import org.eclipse.emf.cdo.ui.CDOEditorInput3;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class CDOModelEditorInput
extends PlatformObject
implements CDOEditorInput2,
CDOEditorInput3,
IPersistableElement {
    protected static final String URI_TAG = "uri";
    private final URI uri;
    private CDOCheckout checkout;
    private CDOView view;
    private String resourcePath;
    private CDOID objectID;

    public CDOModelEditorInput(URI uri) {
        CheckUtil.checkArg((Object)uri, (String)"uri is null");
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public CDOCheckout getCheckout() {
        if (this.checkout == null) {
            this.checkout = CDOExplorerUtil.getCheckout((Object)this.uri);
        }
        return this.checkout;
    }

    public CDOView getView() {
        return this.view;
    }

    public CDOView openView(IProgressMonitor progressMonitor) {
        if (this.view == null) {
            CDOCheckout checkout = this.getCheckout();
            EclipseMonitor monitor = new EclipseMonitor(progressMonitor, "Opening checkout...");
            monitor.begin();
            try {
                OMMonitor.Async async = monitor.forkAsync();
                try {
                    try {
                        checkout.open();
                        progressMonitor.setTaskName("Opening view...");
                        this.view = checkout.openView();
                        this.configureView(this.view);
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        Object message = ex.getLocalizedMessage();
                        if (StringUtil.isEmpty((String)message)) {
                            message = "Could not open checkout.";
                        }
                        message = (String)message + "\nCheck the error log for details.";
                        progressMonitor.setTaskName((String)message);
                        async.stop();
                    }
                }
                finally {
                    async.stop();
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.view;
    }

    public boolean isViewOwned() {
        return true;
    }

    public String getResourcePath() {
        if (this.resourcePath == null) {
            this.resourcePath = CDOURIUtil.extractResourcePath((URI)this.uri);
        }
        return this.resourcePath;
    }

    public CDOID getObjectID() {
        if (this.objectID == null) {
            CDOView view;
            ResourceSet resourceSet;
            EObject eObject;
            CDOObject cdoObject;
            this.objectID = CDOID.NULL;
            if (this.uri.hasFragment() && (cdoObject = CDOUtil.getCDOObject((EObject)(eObject = (resourceSet = (view = this.getView()).getResourceSet()).getEObject(this.uri, true)))) != null) {
                this.objectID = cdoObject.cdoID();
            }
        }
        return this.objectID == CDOID.NULL ? null : this.objectID;
    }

    public void setObjectID(CDOID objectID) {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        CDOView view = this.getView();
        return CDOItemProvider.getViewImageDescriptor((CDOView)view);
    }

    public String getName() {
        String resourcePath = this.getResourcePath();
        if (resourcePath != null) {
            return new Path(resourcePath).lastSegment();
        }
        return this.getView().getSession().getRepositoryInfo().getName();
    }

    public String getToolTipText() {
        String resourcePath = this.getResourcePath();
        CDOCheckout checkout = this.getCheckout();
        if (checkout == null || !checkout.isOpen()) {
            return this.uri.toString();
        }
        return resourcePath + " [" + checkout.getLabel() + "]";
    }

    public IPersistableElement getPersistable() {
        if (OM.PREF_REMEMBER_OPEN_EDITORS.getValue() == Boolean.TRUE) {
            return this;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        memento.putString(URI_TAG, this.uri.toString());
    }

    public String getFactoryId() {
        return "org.eclipse.emf.cdo.explorer.ui.checkouts.CDOModelEditorInput.ElementFactory";
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof CDOModelEditorInput && this.uri.equals(((CDOModelEditorInput)((Object)o)).getURI());
    }

    protected void configureView(CDOView view) {
        if (view instanceof CDOTransaction) {
            this.configureTransaction((CDOTransaction)view);
        }
    }

    protected void configureTransaction(CDOTransaction transaction) {
        CDOModelEditorOpener.addConflictResolver(transaction);
    }

    public static class ElementFactory
    implements IElementFactory {
        public static final String ID = "org.eclipse.emf.cdo.explorer.ui.checkouts.CDOModelEditorInput.ElementFactory";

        public IAdaptable createElement(IMemento memento) {
            URI uri = URI.createURI((String)memento.getString(CDOModelEditorInput.URI_TAG));
            return new CDOModelEditorInput(uri);
        }
    }
}

