/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.edit.ui;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.css.core.internal.cleanup.CleanupProcessorCSS;
import org.eclipse.wst.css.ui.internal.CSSUIMessages;
import org.eclipse.wst.css.ui.internal.edit.ui.CleanupDialogCSS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class CleanupActionCSSDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IEditorPart fEditor;
    private IStructuredCleanupProcessor fCleanupProcessor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
    }

    public void dispose() {
        this.fEditor = null;
        this.fCleanupProcessor = null;
    }

    public void init(IAction action) {
        if (action != null) {
            action.setText(CSSUIMessages.CleanupDocument_label);
            action.setToolTipText(CSSUIMessages.CleanupDocument_tooltip);
            action.setDescription(CSSUIMessages.CleanupDocument_description);
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        ITextEditor editor;
        CleanupDialogCSS cleanupDialog;
        if (this.fEditor instanceof ITextEditor && (cleanupDialog = new CleanupDialogCSS((editor = (ITextEditor)this.fEditor).getSite().getShell())).open() == 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IStructuredCleanupProcessor cleanupProcessor = CleanupActionCSSDelegate.this.getCleanupProcessor();
                    if (cleanupProcessor != null) {
                        IStructuredModel model = null;
                        try {
                            model = StructuredModelManager.getModelManager().getExistingModelForEdit(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
                            if (model != null) {
                                cleanupProcessor.cleanupModel(model);
                            }
                        }
                        finally {
                            if (model != null) {
                                model.releaseFromEdit();
                            }
                        }
                    }
                }
            };
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForEdit(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
                if (model != null) {
                    ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                    model.beginRecording((Object)this, SSEUIMessages.Cleanup_Document_UI_, SSEUIMessages.Cleanup_Document_UI_, selection.getOffset(), selection.getLength());
                    model.aboutToChangeModel();
                    BusyIndicator.showWhile((Display)this.fEditor.getEditorSite().getWorkbenchWindow().getShell().getDisplay(), (Runnable)runnable);
                }
            }
            finally {
                if (model != null) {
                    model.changedModel();
                    ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                    model.endRecording((Object)this, selection.getOffset(), selection.getLength());
                    model.releaseFromEdit();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    IStructuredCleanupProcessor getCleanupProcessor() {
        if (this.fCleanupProcessor == null) {
            this.fCleanupProcessor = new CleanupProcessorCSS();
        }
        return this.fCleanupProcessor;
    }
}

