/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.command.StatefulCommandContext;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedBoolean;

public abstract class AbstractStatefulCommandContext<E extends CommandContext>
implements StatefulCommandContext {
    protected final SynchronizedBoolean active = new SynchronizedBoolean(false);
    protected final E commandContext;

    protected AbstractStatefulCommandContext(E commandContext) {
        if (commandContext == null) {
            throw new NullPointerException();
        }
        this.commandContext = commandContext;
    }

    @Override
    public synchronized void start() {
        if (this.active.isTrue()) {
            throw new IllegalStateException("Not stopped.");
        }
        this.active.setTrue();
    }

    @Override
    public void execute(Command command) {
        if (this.active.isTrue()) {
            this.commandContext.execute(command);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.active.isFalse()) {
            throw new IllegalStateException("Not started.");
        }
        this.active.setFalse();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.commandContext);
    }
}

