"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.areRangesEqual = areRangesEqual;
exports.modifyRange = modifyRange;
exports.rangeContains = rangeContains;
exports.rangeIntersects = rangeIntersects;
const vscode_languageserver_protocol_1 = require("vscode-languageserver-protocol");
const position_1 = require("./position");
function areRangesEqual(a, b) {
    return (0, position_1.arePositionsEqual)(a.start, b.start) && (0, position_1.arePositionsEqual)(a.end, b.end);
}
function modifyRange(range, start, end) {
    return {
        start: start ?? range.start,
        end: end ?? range.end,
    };
}
function rangeContains(range, other) {
    if (vscode_languageserver_protocol_1.Range.is(other)) {
        return rangeContains(range, other.start) && rangeContains(range, other.end);
    }
    return !(0, position_1.isBefore)(other, range.start) && !(0, position_1.isBefore)(range.end, other);
}
function rangeIntersects(a, b) {
    if (rangeContains(a, b.start) || rangeContains(a, b.end)) {
        return true;
    }
    // Check case where `a` is entirely contained in `b`
    return rangeContains(b, a.start) || rangeContains(b, a.end);
}
//# sourceMappingURL=range.js.map