/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.html;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.internal.text.html.HTMLMessages;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.text.readers.SubstitutionReader;

public class HTML2TextReader
extends SubstitutionReader {
    private static final String EMPTY_STRING = "";
    private static final Map<String, String> fgEntityLookup;
    private static final Set<String> fgTags;
    private int fCounter = 0;
    private final TextPresentation fTextPresentation;
    private int fBold = 0;
    private int fItalic = 0;
    private int fStrikeout = 0;
    private boolean fInParagraph = false;
    private boolean fIgnore = false;
    private boolean fHeaderDetected = false;
    private StyleRange fCurrentStyleRange;

    static {
        fgTags = new HashSet<String>();
        fgTags.add("b");
        fgTags.add("strong");
        fgTags.add("br");
        fgTags.add("br/");
        fgTags.add("div");
        fgTags.add("del");
        fgTags.add("strike");
        fgTags.add("s");
        fgTags.add("em");
        fgTags.add("i");
        fgTags.add("h1");
        fgTags.add("h2");
        fgTags.add("h3");
        fgTags.add("h4");
        fgTags.add("h5");
        fgTags.add("p");
        fgTags.add("dl");
        fgTags.add("dt");
        fgTags.add("dd");
        fgTags.add("li");
        fgTags.add("ul");
        fgTags.add("pre");
        fgTags.add("head");
        fgEntityLookup = new HashMap<String, String>(7);
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
    }

    public HTML2TextReader(Reader reader, TextPresentation presentation) {
        super((Reader)new PushbackReader(reader));
        this.fTextPresentation = presentation;
        this.fCurrentStyleRange = new StyleRange();
        this.fCurrentStyleRange.start = 0;
    }

    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            ++this.fCounter;
        }
        return c;
    }

    protected void startBold() {
        if (this.fBold == 0) {
            this.finishAndReinitializeCurrentStyle(this.fCounter);
            this.fCurrentStyleRange.fontStyle |= 1;
        }
        ++this.fBold;
    }

    protected void startItalic() {
        if (this.fItalic == 0) {
            this.finishAndReinitializeCurrentStyle(this.fCounter);
            this.fCurrentStyleRange.fontStyle |= 2;
        }
        ++this.fItalic;
    }

    protected void stopItalic() {
        --this.fItalic;
        if (this.fItalic == 0) {
            this.finishAndReinitializeCurrentStyle(this.fCounter);
            this.fCurrentStyleRange.fontStyle ^= 2;
        }
    }

    protected void stopBold() {
        --this.fBold;
        if (this.fBold == 0) {
            this.finishAndReinitializeCurrentStyle(this.fCounter);
            this.fCurrentStyleRange.fontStyle ^= 1;
        }
    }

    protected void startStrikeout() {
        if (this.fStrikeout == 0) {
            this.finishAndReinitializeCurrentStyle(this.fCounter);
            this.fCurrentStyleRange.strikeout = true;
        }
        ++this.fStrikeout;
    }

    protected void stopStrikeout() {
        --this.fStrikeout;
        if (this.fStrikeout == 0) {
            this.finishAndReinitializeCurrentStyle(this.fCounter);
            this.fCurrentStyleRange.strikeout = false;
        }
    }

    private void finishAndReinitializeCurrentStyle(int offset) {
        if (this.fTextPresentation != null && offset != this.fCurrentStyleRange.start && !HTML2TextReader.isDefaultStyleRange(this.fCurrentStyleRange)) {
            this.fCurrentStyleRange.length = offset - this.fCurrentStyleRange.start;
            this.fTextPresentation.addStyleRange(this.fCurrentStyleRange);
        }
        this.fCurrentStyleRange = (StyleRange)this.fCurrentStyleRange.clone();
        this.fCurrentStyleRange.start = offset;
        this.fCurrentStyleRange.length = 0;
    }

    private static boolean isDefaultStyleRange(StyleRange styleRange) {
        return styleRange.equals((Object)new StyleRange(styleRange.start, styleRange.length, null, null));
    }

    protected void startPreformattedText() {
        this.setSkipWhitespace(false);
    }

    protected void stopPreformattedText() {
        this.setSkipWhitespace(true);
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 60) {
            return this.processHTMLTag();
        }
        if (this.fIgnore) {
            return EMPTY_STRING;
        }
        if (c == 38) {
            return this.processEntity();
        }
        return null;
    }

    private String html2Text(String html) {
        if (html == null || html.isEmpty()) {
            return EMPTY_STRING;
        }
        String tag = html = html.toLowerCase();
        if ('/' == tag.charAt(0)) {
            tag = tag.substring(1);
        }
        if (!fgTags.contains(tag)) {
            return EMPTY_STRING;
        }
        if ("pre".equals(html)) {
            this.startPreformattedText();
            return EMPTY_STRING;
        }
        if ("/pre".equals(html)) {
            this.stopPreformattedText();
            return EMPTY_STRING;
        }
        if ("i".equals(html) || "em".equals(html)) {
            this.startItalic();
            return EMPTY_STRING;
        }
        if ("/i".equals(html) || "/em".equals(html)) {
            this.stopItalic();
            return EMPTY_STRING;
        }
        if ("b".equals(html) || "strong".equals(html)) {
            this.startBold();
            return EMPTY_STRING;
        }
        if ("del".equals(html) || "s".equals(html) || "strike".equals(html)) {
            this.startStrikeout();
            return EMPTY_STRING;
        }
        if (html.length() > 1 && html.charAt(0) == 'h' && Character.isDigit(html.charAt(1)) || "dt".equals(html)) {
            this.startBold();
            return EMPTY_STRING;
        }
        if ("dl".equals(html)) {
            return LINE_DELIM;
        }
        if ("dd".equals(html)) {
            return "\t";
        }
        if ("li".equals(html)) {
            return LINE_DELIM + HTMLMessages.getString("HTML2TextReader.listItemPrefix");
        }
        if ("/b".equals(html) || "/strong".equals(html)) {
            this.stopBold();
            return EMPTY_STRING;
        }
        if ("/del".equals(html) || "/s".equals(html) || "/strike".equals(html)) {
            this.stopStrikeout();
            return EMPTY_STRING;
        }
        if ("p".equals(html)) {
            this.fInParagraph = true;
            return LINE_DELIM;
        }
        if ("br".equals(html) || "br/".equals(html) || "div".equals(html)) {
            return LINE_DELIM;
        }
        if ("/p".equals(html)) {
            boolean inParagraph = this.fInParagraph;
            this.fInParagraph = false;
            return inParagraph ? EMPTY_STRING : LINE_DELIM;
        }
        if (html.startsWith("/h") && html.length() > 2 && Character.isDigit(html.charAt(2)) || "/dt".equals(html)) {
            this.stopBold();
            return LINE_DELIM;
        }
        if ("/dd".equals(html)) {
            return LINE_DELIM;
        }
        if ("head".equals(html) && !this.fHeaderDetected) {
            this.fHeaderDetected = true;
            this.fIgnore = true;
            return EMPTY_STRING;
        }
        if ("/head".equals(html) && this.fHeaderDetected && this.fIgnore) {
            this.fIgnore = false;
            return EMPTY_STRING;
        }
        return EMPTY_STRING;
    }

    private String processHTMLTag() throws IOException {
        StringBuilder buf = new StringBuilder();
        while (true) {
            int ch = this.nextChar();
            while (ch != -1 && ch != 62) {
                buf.append(Character.toLowerCase((char)ch));
                ch = this.nextChar();
                if (ch == 34) {
                    buf.append(Character.toLowerCase((char)ch));
                    ch = this.nextChar();
                    while (ch != -1 && ch != 34) {
                        buf.append(Character.toLowerCase((char)ch));
                        ch = this.nextChar();
                    }
                }
                if (ch != 60 || HTML2TextReader.isInComment(buf)) continue;
                this.unread(ch);
                return "<" + buf.toString();
            }
            if (ch == -1) {
                return null;
            }
            if (!HTML2TextReader.isInComment(buf) || HTML2TextReader.isCommentEnd(buf)) break;
            buf.append((char)ch);
        }
        return this.html2Text(buf.toString());
    }

    private static boolean isInComment(StringBuilder buf) {
        return buf.length() >= 3 && "!--".equals(buf.substring(0, 3));
    }

    private static boolean isCommentEnd(StringBuilder buf) {
        int tagLen = buf.length();
        return tagLen >= 5 && "--".equals(buf.substring(tagLen - 2));
    }

    private void unread(int ch) throws IOException {
        ((PushbackReader)this.getReader()).unread(ch);
    }

    protected String entity2Text(String symbol) {
        if (symbol.length() > 1 && symbol.charAt(0) == '#') {
            try {
                int ch = symbol.charAt(1) == 'x' ? Integer.parseInt(symbol.substring(2), 16) : Integer.parseInt(symbol.substring(1), 10);
                return EMPTY_STRING + (char)ch;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String str = fgEntityLookup.get(symbol);
            if (str != null) {
                return str;
            }
        }
        return "&" + symbol + ";";
    }

    private String processEntity() throws IOException {
        StringBuilder buf = new StringBuilder();
        int ch = this.nextChar();
        while (Character.isLetterOrDigit((char)ch) || ch == 35) {
            buf.append((char)ch);
            ch = this.nextChar();
        }
        if (ch == 59) {
            return this.entity2Text(buf.toString());
        }
        buf.insert(0, '&');
        if (ch != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

