/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;

public class ArchiveURIConverter
extends URIConverterImpl {
    private IArchive archive = null;
    protected Map<URI, IPath> uriToPathMap = new HashMap<URI, IPath>();
    protected Map<IPath, URI> pathToURIMap = new HashMap<IPath, URI>();

    public ArchiveURIConverter(IArchive archive) {
        this.archive = archive;
    }

    public IArchive getArchive() {
        return this.archive;
    }

    public final URI getURI(IPath path) {
        if (!this.pathToURIMap.containsKey(path)) {
            URI uri = this.convertPathToURI(path);
            this.uriToPathMap.put(uri, path);
            this.pathToURIMap.put(path, uri);
            return uri;
        }
        return this.pathToURIMap.get(path);
    }

    protected URI convertPathToURI(IPath path) {
        return URI.createURI((String)path.toString());
    }

    protected IPath convertURIToPath(URI uri) {
        return new Path(uri.toString());
    }

    public final IPath getPath(URI uri) {
        if (!this.uriToPathMap.containsKey(uri)) {
            IPath path = this.convertURIToPath(uri);
            this.uriToPathMap.put(uri, path);
            this.pathToURIMap.put(path, uri);
            return path;
        }
        return this.uriToPathMap.get(uri);
    }

    public InputStream createInputStream(URI uri) throws IOException {
        IPath path = this.getPath(uri);
        IArchiveResource archiveResource = this.getArchive().getArchiveResource(path);
        return archiveResource.getInputStream();
    }
}

