/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.hyperlink;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.html.core.internal.validate.ModuleCoreSupport;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.Logger;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnchorHyperlinkDetector
extends AbstractHyperlinkDetector {
    private void addHyperLinkForHref(ITextViewer textViewer, IRegion linkRegion, Element element, String hrefValue, List links, Node anchor) {
        String name;
        Node nameNode = anchor.getAttributes().getNamedItem("href");
        if (nameNode != null && hrefValue.equals(name = nameNode.getNodeValue()) && nameNode instanceof IndexedRegion) {
            links.add(new InternalElementHyperlink(textViewer, linkRegion, nameNode));
        }
    }

    private void addHyperLinkForName(ITextViewer textViewer, IRegion linkRegion, Element element, String anchorName, List links, Node anchor) {
        String name;
        Node nameNode = anchor.getAttributes().getNamedItem("name");
        if (nameNode != null && anchorName.equals(name = nameNode.getNodeValue()) && nameNode instanceof IndexedRegion) {
            links.add(new InternalElementHyperlink(textViewer, linkRegion, nameNode));
        }
        if ((nameNode = anchor.getAttributes().getNamedItem("id")) != null && anchorName.equals(name = nameNode.getNodeValue()) && nameNode instanceof IndexedRegion) {
            links.add(new InternalElementHyperlink(textViewer, linkRegion, nameNode));
        }
    }

    private IRegion createHyperlinkRegion(IStructuredDocumentRegion documentRegion, ITextRegion valueRegion) {
        return new Region(documentRegion.getStartOffset(valueRegion), valueRegion.getTextLength());
    }

    IHyperlink[] createHyperlinksToAnchorNamed(ITextViewer textViewer, IRegion hyperlinkRegion, Element element, String anchorName, boolean canShowMultipleHyperlinks) {
        ArrayList<ExternalElementHyperlink> links = new ArrayList<ExternalElementHyperlink>(1);
        if (anchorName.length() > 1 && anchorName.startsWith("#")) {
            NodeList anchors = null;
            String internalAnchorName = anchorName.substring(1);
            anchors = element.getOwnerDocument().getElementsByTagName("*");
            int i = 0;
            while (i < anchors.getLength()) {
                this.addHyperLinkForName(textViewer, hyperlinkRegion, element, internalAnchorName, links, anchors.item(i));
                ++i;
            }
        } else {
            links.add(new ExternalElementHyperlink(textViewer.getTextWidget().getDisplay(), hyperlinkRegion, anchorName, element));
        }
        if (!links.isEmpty()) {
            return links.toArray(new IHyperlink[links.size()]);
        }
        return null;
    }

    IHyperlink[] createReferrerHyperlinks(ITextViewer textViewer, IRegion hyperlinkRegion, Element element, String nameValue, boolean canShowMultipleHyperlinks) {
        ArrayList links = new ArrayList(1);
        if (nameValue.length() > 0) {
            String target = "#" + nameValue;
            NodeList anchors = null;
            anchors = element.getOwnerDocument().getElementsByTagName("*");
            int i = 0;
            while (i < anchors.getLength()) {
                this.addHyperLinkForHref(textViewer, hyperlinkRegion, element, target, links, anchors.item(i));
                ++i;
            }
        }
        if (!links.isEmpty()) {
            return links.toArray(new IHyperlink[links.size()]);
        }
        return null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Node currentNode;
        IDocument document;
        if (textViewer != null && region != null && (document = textViewer.getDocument()) != null && (currentNode = this.getCurrentNode(document, region.getOffset())) != null && currentNode.getNodeType() == 1) {
            Element element = (Element)currentNode;
            IStructuredDocumentRegion documentRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(region.getOffset());
            ITextRegion textRegion = documentRegion.getRegionAtCharacterOffset(region.getOffset());
            ITextRegion nameRegion = null;
            ITextRegion valueRegion = null;
            String name = null;
            String value = null;
            if (textRegion != null) {
                int index;
                ITextRegionList regions;
                if ("XML_TAG_ATTRIBUTE_VALUE".equals(textRegion.getType())) {
                    regions = documentRegion.getRegions();
                    index = regions.indexOf(textRegion);
                    if (index >= 4) {
                        nameRegion = regions.get(index - 2);
                        valueRegion = textRegion;
                        name = documentRegion.getText(nameRegion);
                        value = StringUtils.strip((String)documentRegion.getText(valueRegion));
                    }
                } else if ("XML_TAG_ATTRIBUTE_NAME".equals(textRegion.getType()) && (index = (regions = documentRegion.getRegions()).indexOf(textRegion)) <= regions.size() - 3) {
                    nameRegion = textRegion;
                    valueRegion = regions.get(index + 2);
                    name = documentRegion.getText(nameRegion);
                    value = StringUtils.strip((String)documentRegion.getText(valueRegion));
                }
            }
            if (name != null && value != null) {
                int idx = -1;
                if ("href".equalsIgnoreCase(name) && (idx = value.indexOf("#")) >= 0) {
                    Path basePath;
                    String anchorName;
                    String filename = value.substring(0, idx);
                    String string = anchorName = idx < value.length() - 1 ? value.substring(idx + 1) : null;
                    if (anchorName != null && (basePath = new Path(((IDOMNode)element).getModel().getBaseLocation())).segmentCount() > 1) {
                        if (filename.length() == 0) {
                            filename = basePath.lastSegment();
                        }
                        IPath resolved = ModuleCoreSupport.resolve((IPath)basePath, (String)filename);
                        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resolved);
                        if (targetFile.isAccessible()) {
                            return this.createHyperlinksToAnchorNamed(textViewer, this.createHyperlinkRegion(documentRegion, valueRegion), element, value, canShowMultipleHyperlinks);
                        }
                    }
                }
                if ("name".equalsIgnoreCase(name) || "id".equalsIgnoreCase(name)) {
                    return this.createReferrerHyperlinks(textViewer, this.createHyperlinkRegion(documentRegion, valueRegion), element, value, canShowMultipleHyperlinks);
                }
            }
        }
        return null;
    }

    private Node getCurrentNode(IDocument document, int offset) {
        IndexedRegion inode = null;
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel != null && (inode = sModel.getIndexedRegion(offset)) == null) {
                inode = sModel.getIndexedRegion(offset - 1);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }

    static class ExternalElementHyperlink
    implements IHyperlink {
        private String fAnchorName = null;
        private Element fBaseElement = null;
        private Display fDisplay = null;
        private IRegion fHyperlinkRegion = null;

        public ExternalElementHyperlink(Display display, IRegion hyperlinkRegion, String anchorName, Element baseElement) {
            this.fDisplay = display;
            this.fHyperlinkRegion = hyperlinkRegion;
            this.fAnchorName = anchorName;
            this.fBaseElement = baseElement;
        }

        IStatus _open() {
            if (this.fBaseElement instanceof IDOMNode) {
                Path basePath;
                StringTokenizer tokenizer = new StringTokenizer(this.fAnchorName, "#");
                String filename = null;
                String anchorName = null;
                if (tokenizer.hasMoreTokens()) {
                    try {
                        filename = tokenizer.nextToken();
                        anchorName = tokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                if (filename != null && anchorName != null && (basePath = new Path(((IDOMNode)this.fBaseElement).getModel().getBaseLocation())).segmentCount() > 1) {
                    IPath resolved = ModuleCoreSupport.resolve((IPath)basePath, (String)filename);
                    IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resolved);
                    if (targetFile.isAccessible()) {
                        IStructuredModel model = null;
                        int start = -1;
                        int end = -1;
                        try {
                            model = StructuredModelManager.getModelManager().getModelForRead(targetFile);
                            if (model instanceof IDOMModel) {
                                String name;
                                Node nameNode;
                                Node item;
                                NodeList anchors = ((IDOMModel)model).getDocument().getElementsByTagNameNS("*", "A");
                                int i = 0;
                                while (i < anchors.getLength() && start < 0) {
                                    item = anchors.item(i);
                                    nameNode = item.getAttributes().getNamedItem("name");
                                    if (nameNode == null) {
                                        nameNode = item.getAttributes().getNamedItem("id");
                                    }
                                    if (nameNode != null && anchorName.equals(name = nameNode.getNodeValue()) && nameNode instanceof IndexedRegion) {
                                        start = ((IndexedRegion)nameNode).getStartOffset();
                                        end = ((IndexedRegion)nameNode).getEndOffset();
                                    }
                                    ++i;
                                }
                                anchors = ((IDOMModel)model).getDocument().getElementsByTagName("A");
                                i = 0;
                                while (i < anchors.getLength() && start < 0) {
                                    item = anchors.item(i);
                                    nameNode = item.getAttributes().getNamedItem("name");
                                    if (nameNode == null) {
                                        nameNode = item.getAttributes().getNamedItem("id");
                                    }
                                    if (nameNode != null && anchorName.equals(name = nameNode.getNodeValue()) && nameNode instanceof IndexedRegion) {
                                        start = ((IndexedRegion)nameNode).getStartOffset();
                                        end = ((IndexedRegion)nameNode).getEndOffset();
                                    }
                                    ++i;
                                }
                                anchors = ((IDOMModel)model).getDocument().getElementsByTagName("*");
                                i = 0;
                                while (i < anchors.getLength() && start < 0) {
                                    item = anchors.item(i);
                                    nameNode = item.getAttributes().getNamedItem("name");
                                    if (nameNode == null) {
                                        nameNode = item.getAttributes().getNamedItem("id");
                                    }
                                    if (nameNode != null && anchorName.equals(name = nameNode.getNodeValue()) && nameNode instanceof IndexedRegion) {
                                        start = ((IndexedRegion)nameNode).getStartOffset();
                                        end = ((IndexedRegion)nameNode).getEndOffset();
                                    }
                                    ++i;
                                }
                            }
                            IStatus iStatus = this.open(basePath.toString(), targetFile, start, end);
                            return iStatus;
                        }
                        catch (Exception e) {
                            Logger.logException(e);
                            Status status = new Status(4, "org.eclipse.wst.html.ui", e.getMessage());
                            return status;
                        }
                        finally {
                            if (model != null) {
                                model.releaseFromRead();
                            }
                        }
                    }
                }
            }
            return Status.OK_STATUS;
        }

        public IRegion getHyperlinkRegion() {
            return this.fHyperlinkRegion;
        }

        public String getHyperlinkText() {
            return NLS.bind((String)HTMLUIMessages.Open, (Object)this.fAnchorName);
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            this.scheduleOpen();
        }

        private IStatus open(String base, IFile targetFile, int start, int end) throws CoreException, PartInitException {
            IMarker temporaryMarker = null;
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)targetFile);
                if (start >= 0 && start <= end) {
                    temporaryMarker = targetFile.createMarker("org.eclipse.core.resources.bookmark");
                    temporaryMarker.setAttribute("message", (Object)base);
                    temporaryMarker.setAttribute("charStart", start);
                    temporaryMarker.setAttribute("charEnd", end);
                    IDE.gotoMarker((IEditorPart)editor, (IMarker)temporaryMarker);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (temporaryMarker != null) {
                    try {
                        temporaryMarker.delete();
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
            }
        }

        void scheduleOpen() {
            UIJob opener = new UIJob(this.fDisplay, this.fAnchorName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    return this._open();
                }
            };
            opener.setSystem(true);
            opener.setUser(false);
            opener.schedule();
        }
    }

    static class InternalElementHyperlink
    implements IHyperlink {
        private IRegion fHyperlinkRegion;
        private Node fTarget = null;
        private ITextViewer fViewer = null;

        public InternalElementHyperlink(ITextViewer textViewer, IRegion hyperlinkRegion, Node targetNode) {
            this.fHyperlinkRegion = hyperlinkRegion;
            this.fTarget = targetNode;
            this.fViewer = textViewer;
        }

        public IRegion getHyperlinkRegion() {
            return this.fHyperlinkRegion;
        }

        public String getHyperlinkText() {
            if (this.fTarget instanceof IndexedRegion) {
                try {
                    int line = this.fViewer.getDocument().getLineOfOffset(((IndexedRegion)this.fTarget).getStartOffset()) + 1;
                    return NLS.bind((String)HTMLUIMessages.Hyperlink_line, (Object[])new String[]{this.fTarget.getNodeName(), this.fTarget.getNodeValue(), String.valueOf(line)});
                }
                catch (BadLocationException e) {
                    Logger.logException(e);
                }
            }
            return NLS.bind((String)HTMLUIMessages.Open, (Object)this.fTarget.getNodeName());
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            if (this.fTarget instanceof IndexedRegion) {
                int offset = ((IndexedRegion)this.fTarget).getStartOffset();
                if (this.fViewer instanceof ITextViewerExtension5) {
                    offset = ((ITextViewerExtension5)this.fViewer).modelOffset2WidgetOffset(offset);
                }
                this.fViewer.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, 0));
                this.fViewer.revealRange(offset, 0);
            }
        }
    }
}

