/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardSelectionPage;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizardCategoryFilter;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.NewDbDataSourceWizardBase;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.OdaDbProfileWizardNode;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.IProfileWizardProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class DbTypesSelectionPage
extends CPWizardSelectionPage {
    private static final ViewerFilter[] sm_viewerFilters = new ViewerFilter[]{new NewCPWizardCategoryFilter("org.eclipse.datatools.connectivity.db.category"), new DbProfileWizardFilter()};

    DbTypesSelectionPage() {
        super(DbTypesSelectionPage.class.getName(), sm_viewerFilters);
    }

    public List getCategoryItems(String wizardCategory) {
        List baseWizardNodes = super.getCategoryItems(wizardCategory);
        if (baseWizardNodes == null || baseWizardNodes.isEmpty()) {
            return baseWizardNodes;
        }
        assert (this.getWizard() instanceof NewDbDataSourceWizardBase);
        NewDbDataSourceWizardBase sessionWizard = (NewDbDataSourceWizardBase)this.getWizard();
        ArrayList wrappedWizardNodes = new ArrayList();
        for (Object wizardNode : baseWizardNodes) {
            if (wizardNode.getClass() == CPWizardNode.class) {
                wizardNode = new OdaDbProfileWizardNode(((CPWizardNode)wizardNode).getProvider(), sessionWizard);
            }
            wrappedWizardNodes.add(wizardNode);
        }
        return wrappedWizardNodes;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setProfileNameVisible(false);
        this.setProfileDescriptionVisible(false);
    }

    public IWizardPage getNextPage() {
        boolean arePageControlsCreated = this.getSelectedNode() != null && this.getSelectedNode().isContentCreated();
        IWizardPage wizardPage = super.getNextPage();
        if (!arePageControlsCreated && wizardPage instanceof ConnectionProfileDetailsPage) {
            ((ConnectionProfileDetailsPage)wizardPage).setCreateAutoConnectControls(false);
        }
        return wizardPage;
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            return true;
        }
        if (this.getSelectedNode() != null) {
            IWizard cpNodeWizard = this.getSelectedNodeWizard();
            return cpNodeWizard != null && cpNodeWizard.canFinish();
        }
        return false;
    }

    IWizard getSelectedNodeWizard() {
        if (this.getSelectedNode() == null) {
            return null;
        }
        return this.getSelectedNode().getWizard();
    }

    static class DbProfileWizardFilter
    extends ViewerFilter {
        DbProfileWizardFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof CPWizardNode)) {
                return true;
            }
            CPWizardNode wizardNode = (CPWizardNode)element;
            if (!(wizardNode.getProvider() instanceof IProfileWizardProvider)) {
                return true;
            }
            IProfileWizardProvider profileWizProvider = wizardNode.getProvider();
            IWizard profileWizard = profileWizProvider.getWizard();
            boolean dbWrapperWizard = profileWizard instanceof NewDbDataSourceWizardBase;
            return !dbWrapperWizard;
        }
    }
}

