/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.reference.ModifiableObjectReference;

public class SimpleObjectReference<V>
implements ModifiableObjectReference<V>,
Cloneable,
Serializable {
    private volatile V value;
    private static final long serialVersionUID = 1L;

    public SimpleObjectReference(V value) {
        this.value = value;
    }

    public SimpleObjectReference() {
        this(null);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public boolean valueEquals(Object object) {
        return ObjectTools.equals(this.value, object);
    }

    @Override
    public boolean valueNotEqual(Object object) {
        return ObjectTools.notEquals(this.value, object);
    }

    @Override
    public boolean is(Object object) {
        return this.value == object;
    }

    @Override
    public boolean isNot(Object object) {
        return this.value != object;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isNotNull() {
        return this.value != null;
    }

    @Override
    public boolean isMemberOf(Predicate<? super V> predicate) {
        return predicate.evaluate(this.value);
    }

    @Override
    public boolean isNotMemberOf(Predicate<? super V> predicate) {
        return !predicate.evaluate(this.value);
    }

    @Override
    public V setValue(V value) {
        V old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public V setNull() {
        return this.setValue(null);
    }

    @Override
    public boolean commit(V newValue, V expectedValue) {
        if (ObjectTools.equals(this.value, expectedValue)) {
            this.setValue(newValue);
            return true;
        }
        return false;
    }

    @Override
    public V swap(ModifiableObjectReference<V> other) {
        if (other == this) {
            return this.value;
        }
        Object otherValue = other.getValue();
        if (ObjectTools.equals(this.value, otherValue)) {
            return this.value;
        }
        other.setValue(this.value);
        this.setValue(otherValue);
        return otherValue;
    }

    public SimpleObjectReference<V> clone() {
        try {
            SimpleObjectReference clone = (SimpleObjectReference)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

