/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.exception.DefaultExceptionHandler;
import org.eclipse.jpt.common.utility.internal.factory.CastingFactoryWrapper;
import org.eclipse.jpt.common.utility.internal.factory.CloneFactory;
import org.eclipse.jpt.common.utility.internal.factory.ClosureFactory;
import org.eclipse.jpt.common.utility.internal.factory.CommandFactory;
import org.eclipse.jpt.common.utility.internal.factory.DisabledFactory;
import org.eclipse.jpt.common.utility.internal.factory.DowncastingFactoryWrapper;
import org.eclipse.jpt.common.utility.internal.factory.FactoryWrapper;
import org.eclipse.jpt.common.utility.internal.factory.InstantiationFactory;
import org.eclipse.jpt.common.utility.internal.factory.IteratorFactory;
import org.eclipse.jpt.common.utility.internal.factory.NullFactory;
import org.eclipse.jpt.common.utility.internal.factory.SafeFactoryWrapper;
import org.eclipse.jpt.common.utility.internal.factory.StaticFactory;
import org.eclipse.jpt.common.utility.internal.factory.StaticFieldFactory;
import org.eclipse.jpt.common.utility.internal.factory.StaticMethodFactory;
import org.eclipse.jpt.common.utility.internal.factory.ThreadLocalFactory;
import org.eclipse.jpt.common.utility.internal.factory.TransformerFactory;
import org.eclipse.jpt.common.utility.internal.factory.UpcastingFactoryWrapper;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class FactoryTools {
    public static final Factory[] EMPTY_ARRAY = new Factory[0];

    public static <T> Factory<T> adapt(Iterable<? extends T> iterable) {
        return FactoryTools.adapt(iterable.iterator());
    }

    public static <T> Factory<T> adapt(Iterator<? extends T> iterator) {
        return new IteratorFactory<T>(iterator);
    }

    public static <T> Factory<T> adapt(Closure<?> closure) {
        return new ClosureFactory(closure);
    }

    public static <T> Factory<T> adapt(Command command) {
        return new CommandFactory(command);
    }

    public static <T> Factory<T> adapt(Transformer<?, ? extends T> transformer) {
        return new TransformerFactory<T>(transformer);
    }

    public static <T> ThreadLocalFactory<T> threadLocalFactory() {
        return FactoryTools.threadLocalFactory(NullFactory.instance());
    }

    public static <T> ThreadLocalFactory<T> threadLocalFactory(Factory<? extends T> defaultFactory) {
        return new ThreadLocalFactory<T>(defaultFactory);
    }

    public static <T> FactoryWrapper<T> wrap(Factory<? extends T> factory) {
        return new FactoryWrapper<T>(factory);
    }

    public static <X, T> Factory<T> cast(Factory<X> factory) {
        return new CastingFactoryWrapper(factory);
    }

    public static <X, T extends X> Factory<T> downcast(Factory<X> factory) {
        return new DowncastingFactoryWrapper(factory);
    }

    public static <T, X extends T> Factory<T> upcast(Factory<X> factory) {
        return new UpcastingFactoryWrapper(factory);
    }

    public static <T> Factory<T> safe(Factory<? extends T> factory) {
        return FactoryTools.safe(factory, DefaultExceptionHandler.instance(), null);
    }

    public static <T> Factory<T> safe(Factory<? extends T> factory, T exceptionValue) {
        return FactoryTools.safe(factory, DefaultExceptionHandler.instance(), exceptionValue);
    }

    public static <T> Factory<T> safe(Factory<? extends T> factory, ExceptionHandler exceptionHandler) {
        return FactoryTools.safe(factory, exceptionHandler, null);
    }

    public static <T> Factory<T> safe(Factory<? extends T> factory, ExceptionHandler exceptionHandler, T exceptionValue) {
        return new SafeFactoryWrapper<T>(factory, exceptionHandler, exceptionValue);
    }

    public static <T extends Cloneable> Factory<T> cloneFactory(T prototype) {
        return new CloneFactory<T>(prototype);
    }

    public static <T> Factory<T> instantiationFactory(Class<? extends T> clazz) {
        return FactoryTools.instantiationFactory(clazz, ClassTools.EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <T> Factory<T> instantiationFactory(Class<T> clazz, Class<?> parameterType, Object argument) {
        return FactoryTools.instantiationFactory(clazz, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <T> Factory<T> instantiationFactory(Class<? extends T> clazz, Class<?>[] parameterTypes, Object[] arguments) {
        return new InstantiationFactory<T>(clazz, parameterTypes, arguments);
    }

    public static <T> Factory<T> get(Class<?> clazz, String fieldName) {
        return FactoryTools.get(ClassTools.field(clazz, fieldName));
    }

    public static <T> Factory<T> get(Field field) {
        return new StaticFieldFactory(field);
    }

    public static <T> Factory<T> execute(Class<?> clazz, String methodName) {
        return FactoryTools.execute(clazz, methodName, ClassTools.EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <T> Factory<T> execute(Class<?> clazz, String methodName, Class<?> parameterType, Object argument) {
        return FactoryTools.execute(clazz, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <T> Factory<T> execute(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        return FactoryTools.execute(ClassTools.method(clazz, methodName, parameterTypes), arguments);
    }

    public static <T> Factory<T> execute(Method method, Object[] arguments) {
        return new StaticMethodFactory(method, arguments);
    }

    public static <T> Factory<T> disabledFactory() {
        return DisabledFactory.instance();
    }

    public static <T> Factory<T> nullFactory() {
        return NullFactory.instance();
    }

    public static <T> Factory<T> staticFactory(T value) {
        return new StaticFactory<T>(value);
    }

    public static <T> Factory<T>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    private FactoryTools() {
        throw new UnsupportedOperationException();
    }
}

