/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.coverageview;

import org.eclipse.eclemma.core.analysis.IJavaModelCoverage;
import org.eclipse.eclemma.internal.ui.coverageview.CoverageView;
import org.eclipse.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.ui.model.WorkbenchContentProvider;

class CoveredElementsContentProvider
extends WorkbenchContentProvider {
    private final ViewSettings settings;

    public CoveredElementsContentProvider(ViewSettings settings) {
        this.settings = settings;
    }

    public Object[] getElements(Object element) {
        IJavaModelCoverage coverage = (IJavaModelCoverage)element;
        if (coverage == IJavaModelCoverage.LOADING) {
            return new Object[]{CoverageView.LOADING_ELEMENT};
        }
        if (coverage != null) {
            switch (this.settings.getRootType()) {
                case GROUP: {
                    return coverage.getProjects();
                }
                case BUNDLE: {
                    return coverage.getPackageFragmentRoots();
                }
                case PACKAGE: {
                    return coverage.getPackageFragments();
                }
                case CLASS: {
                    return coverage.getTypes();
                }
            }
        }
        return new Object[0];
    }
}

