/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.runner;

import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.runner.JUnitPlatformTestTree;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

class JUnitPlatformRunnerListener
implements TestExecutionListener {
    private final JUnitPlatformTestTree testTree;
    private final RunNotifier notifier;

    JUnitPlatformRunnerListener(JUnitPlatformTestTree testTree, RunNotifier notifier) {
        this.testTree = testTree;
        this.notifier = notifier;
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        UniqueId parentId = (UniqueId)testIdentifier.getParentIdObject().get();
        this.testTree.addDynamicDescription(testIdentifier, parentId);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isTest()) {
            this.fireTestIgnored(testIdentifier);
        } else {
            this.testTree.getTestsInSubtree(testIdentifier).forEach(this::fireTestIgnored);
        }
    }

    private void fireTestIgnored(TestIdentifier testIdentifier) {
        Description description = this.findJUnit4Description(testIdentifier);
        this.notifier.fireTestIgnored(description);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        Description description = this.findJUnit4Description(testIdentifier);
        if (description.isTest()) {
            this.notifier.fireTestStarted(description);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Description description = this.findJUnit4Description(testIdentifier);
        TestExecutionResult.Status status = testExecutionResult.getStatus();
        if (status == TestExecutionResult.Status.ABORTED) {
            this.notifier.fireTestAssumptionFailed(this.toFailure(testExecutionResult, description));
        } else if (status == TestExecutionResult.Status.FAILED) {
            this.notifier.fireTestFailure(this.toFailure(testExecutionResult, description));
        }
        if (description.isTest()) {
            this.notifier.fireTestFinished(description);
        }
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        System.out.println(entry);
    }

    public void fileEntryPublished(TestIdentifier testIdentifier, FileEntry file) {
        System.out.println(file);
    }

    private Failure toFailure(TestExecutionResult testExecutionResult, Description description) {
        return new Failure(description, (Throwable)testExecutionResult.getThrowable().orElse(null));
    }

    private Description findJUnit4Description(TestIdentifier testIdentifier) {
        return this.testTree.getDescription(testIdentifier);
    }
}

