/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.identity.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.identity.core.Account;
import org.eclipse.mylyn.commons.identity.core.IIdentity;
import org.eclipse.mylyn.commons.identity.core.IProfile;
import org.eclipse.mylyn.commons.identity.core.IProfileImage;
import org.eclipse.mylyn.commons.identity.core.spi.Profile;
import org.eclipse.mylyn.commons.identity.core.spi.ProfileImage;
import org.eclipse.mylyn.internal.commons.identity.core.IdentityModel;
import org.eclipse.mylyn.internal.commons.identity.core.Messages;

public class Identity
implements IIdentity {
    private final Set<Account> accounts;
    private final UUID id;
    private List<ProfileImage> images;
    private final List<PropertyChangeListener> listeners;
    private final IdentityModel model;
    private Profile profile;
    private boolean refreshProfile;

    public Identity(IdentityModel model) {
        this.model = model;
        this.id = UUID.randomUUID();
        this.accounts = new CopyOnWriteArraySet<Account>();
        this.listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    }

    @Override
    public void addAccount(Account account) {
        this.accounts.add(account);
        this.refreshProfile = true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Account[] getAccounts() {
        return this.accounts.toArray(new Account[this.accounts.size()]);
    }

    @Override
    public Account getAccountById(String id) {
        if (id == null) {
            return null;
        }
        for (Account account : this.accounts) {
            if (!id.equals(account.getId())) continue;
            return account;
        }
        return null;
    }

    @Override
    public Account getAccountByKind(String kind) {
        if (kind == null) {
            return null;
        }
        for (Account account : this.accounts) {
            if (!kind.equals(account.getKind())) continue;
            return account;
        }
        return null;
    }

    @Override
    public String[] getAliases() {
        HashSet<String> aliases = new HashSet<String>(this.accounts.size());
        for (Account account : this.accounts) {
            aliases.add(account.getId());
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public boolean is(Account account) {
        return this.accounts.contains(account);
    }

    public boolean is(String id) {
        return this.getAccountById(id) != null;
    }

    @Override
    public void removeAccount(Account account) {
        this.accounts.remove(account);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized Future<IProfileImage> requestImage(final int preferredWidth, final int preferredHeight) {
        if (this.images != null) {
            for (ProfileImage image : this.images) {
                if (image.getWidth() != preferredWidth || image.getHeight() != preferredHeight) continue;
                return new FutureResult<IProfileImage>(image);
            }
        }
        FutureJob<IProfileImage> job = new FutureJob<IProfileImage>(Messages.Identity_Retrieving_Image){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProfileImage image = Identity.this.model.getImage(Identity.this, preferredWidth, preferredHeight, monitor);
                    if (image != null) {
                        Identity.this.addImage(image);
                    }
                    IStatus iStatus = this.success(image);
                    return iStatus;
                }
                catch (Throwable t) {
                    IStatus iStatus = this.error(t);
                    return iStatus;
                }
                finally {
                    this.done();
                }
            }
        };
        job.schedule();
        return job;
    }

    @Override
    public Future<IProfile> requestProfile() {
        if (this.profile != null && !this.refreshProfile) {
            return new FutureResult<IProfile>(this.profile);
        }
        this.refreshProfile = false;
        FutureJob<IProfile> job = new FutureJob<IProfile>(Messages.Identity_Retrieving_Profile){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Profile profile = new Profile(Identity.this);
                    Identity.this.model.updateProfile(profile, monitor);
                    Identity.this.setProfile(profile);
                    IStatus iStatus = this.success(profile);
                    return iStatus;
                }
                catch (Throwable t) {
                    IStatus iStatus = this.error(t);
                    return iStatus;
                }
                finally {
                    this.done();
                }
            }
        };
        job.schedule();
        return job;
    }

    private void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    protected synchronized void addImage(ProfileImage image) {
        if (this.images == null) {
            this.images = new ArrayList<ProfileImage>();
        }
        this.images.add(image);
        this.firePropertyChangeEvent("image", null, image);
    }

    protected synchronized void removeImage(ProfileImage image) {
        if (this.images != null) {
            this.images.remove(image);
        }
    }

    protected void setProfile(Profile profile) {
        this.profile = profile;
    }

    private static abstract class FutureJob<T>
    extends Job
    implements Future<T> {
        private boolean cancelled;
        private final AtomicReference<Throwable> futureException = new AtomicReference();
        private final AtomicReference<T> futureResult = new AtomicReference();
        private final CountDownLatch resultLatch = new CountDownLatch(1);

        public FutureJob(String name) {
            super(name);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            return this.cancel();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.resultLatch.await();
            return this.getFutureResult();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.resultLatch.await(timeout, unit)) {
                throw new TimeoutException();
            }
            return this.getFutureResult();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.getResult() != null;
        }

        private T getFutureResult() throws ExecutionException {
            Throwable t = this.futureException.get();
            if (t != null) {
                throw new ExecutionException(t);
            }
            return this.futureResult.get();
        }

        protected void done() {
            if (this.resultLatch.getCount() > 0L) {
                this.error(new RuntimeException());
            }
            this.resultLatch.countDown();
        }

        protected IStatus error(Throwable t) {
            this.futureException.set(t);
            this.resultLatch.countDown();
            if (t instanceof OperationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        protected IStatus success(T result) {
            this.futureResult.set(result);
            this.resultLatch.countDown();
            return Status.OK_STATUS;
        }
    }

    private static final class FutureResult<T>
    implements Future<T> {
        private final T result;

        private FutureResult(T result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

