/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.Messages;

public class PollingInputStream
extends FilterInputStream {
    private static final boolean DEBUG = Policy.DEBUG_STREAMS;
    private final int numAttempts;
    private final IProgressMonitor monitor;
    private boolean cancellable;

    public PollingInputStream(InputStream in, int numAttempts, IProgressMonitor monitor) {
        super(in);
        this.numAttempts = numAttempts;
        this.monitor = monitor;
        this.cancellable = true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void close() throws InterruptedIOException {
        block26: {
            block25: {
                attempts = 0;
                try {
                    try {
                        this.readPendingInput();
                        break block25;
                    }
                    catch (IOException e) {
                        CommonsNetPlugin.log(4, e.getMessage(), e);
                        stop = false;
                        ** while (!stop)
                    }
                }
                catch (Throwable var3_15) {
                    stop = false;
                    ** while (!stop)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                        stop = true;
                    }
                    catch (InterruptedIOException e) {
                        if (this.checkCancellation()) {
                            throw new OperationCanceledException();
                        }
                        if (++attempts == this.numAttempts) {
                            throw new InterruptedIOException(Messages.PollingInputStream_closeTimeout);
                        }
                        if (!PollingInputStream.DEBUG) continue;
                        System.out.println("close retry=" + attempts);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    continue;
lbl26:
                    // 1 sources

                    break block26;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                        stop = true;
                    }
                    catch (InterruptedIOException e) {
                        if (this.checkCancellation()) {
                            throw new OperationCanceledException();
                        }
                        if (++attempts == this.numAttempts) {
                            throw new InterruptedIOException(Messages.PollingInputStream_closeTimeout);
                        }
                        if (!PollingInputStream.DEBUG) continue;
                        System.out.println("close retry=" + attempts);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    continue;
                }
lbl46:
                // 1 sources

                throw var3_15;
            }
            stop = false;
            while (!stop) {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                    stop = true;
                }
                catch (InterruptedIOException e) {
                    if (this.checkCancellation()) {
                        throw new OperationCanceledException();
                    }
                    if (++attempts == this.numAttempts) {
                        throw new InterruptedIOException(Messages.PollingInputStream_closeTimeout);
                    }
                    if (!PollingInputStream.DEBUG) continue;
                    System.out.println("close retry=" + attempts);
                }
                catch (IOException var5_14) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public int read() throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read();
            }
            catch (InterruptedIOException e) {
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Messages.PollingInputStream_readTimeout);
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read(buffer, off, len);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred != 0) {
                    return e.bytesTransferred;
                }
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Messages.PollingInputStream_readTimeout);
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    @Override
    public long skip(long count) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.skip(count);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred != 0) {
                    return e.bytesTransferred;
                }
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Messages.PollingInputStream_readTimeout);
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    protected void readPendingInput() throws IOException {
        int available;
        byte[] buffer = new byte[2048];
        while ((available = this.in.available()) >= 1) {
            if (available > buffer.length) {
                available = buffer.length;
            }
            if (this.in.read(buffer, 0, available) >= 1) continue;
        }
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private boolean checkCancellation() {
        if (this.cancellable) {
            return this.monitor.isCanceled();
        }
        return false;
    }
}

