/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.views.contentoutline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.sse.ui.internal.filter.OutlineCustomFiltersDialog;
import org.eclipse.wst.sse.ui.internal.filter.OutlineFilterDescriptor;
import org.eclipse.wst.sse.ui.internal.filter.OutlineNamePatternFilter;

public class ContentOutlineFilterProcessor {
    private static final String SEPARATOR = ",";
    private final String TAG_USER_DEFINED_PATTERNS_ENABLED = "userDefinedPatternsEnabled";
    private final String TAG_USER_DEFINED_PATTERNS = "userDefinedPatterns";
    private final StructuredViewer fViewer;
    private final OutlineNamePatternFilter fPatternFilter;
    private boolean fUserDefinedPatternsEnabled;
    private String[] fUserDefinedPatterns;
    private String[] fPreviousPatterns;
    private final Map fFilterItems;
    private final String fTargetId;
    private IPreferenceStore fStore;

    public ContentOutlineFilterProcessor(IPreferenceStore store, String ownerId, StructuredViewer viewer) {
        Assert.isNotNull((Object)ownerId);
        Assert.isNotNull((Object)viewer);
        this.fStore = store;
        this.fTargetId = ownerId;
        this.fViewer = viewer;
        this.fPatternFilter = new OutlineNamePatternFilter();
        this.fUserDefinedPatterns = new String[0];
        this.fUserDefinedPatternsEnabled = false;
        this.fPreviousPatterns = new String[0];
        this.fFilterItems = new HashMap();
        OutlineFilterDescriptor[] filterDescriptors = OutlineFilterDescriptor.getFilterDescriptors(this.fTargetId);
        int i = 0;
        while (i < filterDescriptors.length) {
            FilterItem item = new FilterItem(filterDescriptors[i]);
            this.fFilterItems.put(item.id, item);
            ++i;
        }
        this.initializeWithViewDefaults();
        this.updateViewerFilters();
    }

    public boolean isDynamic() {
        return true;
    }

    public String[] internalGetEnabledFilterIds() {
        ArrayList<String> enabledFilterIds = new ArrayList<String>();
        for (FilterItem item : this.fFilterItems.values()) {
            if (!item.enabled) continue;
            enabledFilterIds.add(item.id);
        }
        return enabledFilterIds.toArray(new String[enabledFilterIds.size()]);
    }

    private void setEnabledFilterIds(String[] enabledIds) {
        this.fUserDefinedPatternsEnabled = false;
        for (FilterItem item : this.fFilterItems.values()) {
            item.enabled = false;
        }
        int i = 0;
        while (i < enabledIds.length) {
            FilterItem item;
            item = (FilterItem)this.fFilterItems.get(enabledIds[i]);
            if (item != null) {
                item.enabled = true;
            }
            if (((Object)((Object)this.fPatternFilter)).getClass().getName().equals(enabledIds[i])) {
                this.fUserDefinedPatternsEnabled = true;
            }
            ++i;
        }
    }

    private void setUserDefinedPatterns(String[] patterns) {
        this.fUserDefinedPatterns = patterns;
    }

    private boolean areUserDefinedPatternsEnabled() {
        return this.fUserDefinedPatternsEnabled;
    }

    private void setUserDefinedPatternsEnabled(boolean state) {
        this.fUserDefinedPatternsEnabled = state;
    }

    private boolean updateViewerFilters() {
        ViewerFilter filter;
        ViewerFilter[] installedFilters = this.fViewer.getFilters();
        ArrayList<ViewerFilter> viewerFilters = new ArrayList<ViewerFilter>(installedFilters.length);
        HashSet<String> patterns = new HashSet<String>();
        boolean hasChange = false;
        boolean patternChange = false;
        for (FilterItem item : this.fFilterItems.values()) {
            if (item.descriptor.isCustomFilter()) {
                if (item.enabled != item.previouslyEnabled) {
                    hasChange = true;
                }
                if (item.enabled && (filter = item.getFilterInstance()) != null) {
                    viewerFilters.add(filter);
                }
            } else if (item.descriptor.isPatternFilter()) {
                if (item.enabled) {
                    patterns.add(item.descriptor.getPattern());
                }
                patternChange |= item.enabled ^ item.previouslyEnabled;
            }
            item.previouslyEnabled = item.enabled;
        }
        if (this.areUserDefinedPatternsEnabled()) {
            int i = 0;
            while (i < this.fUserDefinedPatterns.length) {
                patterns.add(this.fUserDefinedPatterns[i]);
                ++i;
            }
        }
        if (!patternChange) {
            patternChange = this.hasChanges(patterns, this.fPreviousPatterns);
        }
        this.fPreviousPatterns = patterns.toArray(new String[patterns.size()]);
        if (patternChange || hasChange) {
            this.fPatternFilter.setPatterns(this.fPreviousPatterns);
            if (patterns.isEmpty()) {
                viewerFilters.remove((Object)this.fPatternFilter);
            } else if (!viewerFilters.contains((Object)this.fPatternFilter)) {
                boolean contains = false;
                int i = 0;
                while (i < viewerFilters.size()) {
                    if (viewerFilters.get(i) instanceof OutlineNamePatternFilter) {
                        String[] a2;
                        filter = (OutlineNamePatternFilter)((Object)viewerFilters.get(i));
                        String[] a1 = filter.getPatterns();
                        if (a1[0].equals((a2 = this.fPatternFilter.getPatterns())[0])) {
                            contains = true;
                            break;
                        }
                        viewerFilters.remove(i);
                        break;
                    }
                    ++i;
                }
                if (!contains) {
                    viewerFilters.add(this.fPatternFilter);
                }
            }
            hasChange = true;
        }
        if (hasChange) {
            this.fViewer.setFilters(viewerFilters.toArray(new ViewerFilter[viewerFilters.size()]));
        }
        return hasChange;
    }

    private boolean hasChanges(HashSet patterns, String[] oldPatterns) {
        HashSet copy = (HashSet)patterns.clone();
        int i = 0;
        while (i < oldPatterns.length) {
            boolean found = copy.remove(oldPatterns[i]);
            if (!found) {
                return true;
            }
            ++i;
        }
        return !copy.isEmpty();
    }

    private void initializeWithViewDefaults() {
        this.fUserDefinedPatternsEnabled = this.fStore.getBoolean(this.getPreferenceKey("userDefinedPatternsEnabled"));
        this.setUserDefinedPatterns(OutlineCustomFiltersDialog.convertFromString(this.fStore.getString(this.getPreferenceKey("userDefinedPatterns")), SEPARATOR));
        for (FilterItem item : this.fFilterItems.values()) {
            String id = item.id;
            this.fStore.setDefault(id, item.descriptor.isEnabled());
            item.enabled = this.fStore.getBoolean(id);
        }
    }

    private void storeViewDefaults() {
        this.fStore.setValue(this.getPreferenceKey("userDefinedPatternsEnabled"), this.fUserDefinedPatternsEnabled);
        this.fStore.setValue(this.getPreferenceKey("userDefinedPatterns"), OutlineCustomFiltersDialog.convertToString(this.fUserDefinedPatterns, SEPARATOR));
        boolean fFilterSelected = false;
        for (FilterItem item : this.fFilterItems.values()) {
            this.fStore.setValue(item.id, item.enabled);
            if (!item.enabled) continue;
            fFilterSelected = true;
        }
        this.fStore.setValue(this.fTargetId, this.fUserDefinedPatternsEnabled || fFilterSelected);
    }

    private String getPreferenceKey(String tag) {
        return "CustomFiltersActionGroup." + this.fTargetId + '.' + tag;
    }

    public void openDialog() {
        OutlineCustomFiltersDialog dialog = new OutlineCustomFiltersDialog(this.fViewer.getControl().getShell(), this.fTargetId, this.areUserDefinedPatternsEnabled(), this.fUserDefinedPatterns, this.internalGetEnabledFilterIds());
        if (dialog.open() == 0) {
            this.setEnabledFilterIds(dialog.getEnabledFilterIds());
            this.setUserDefinedPatternsEnabled(dialog.areUserDefinedPatternsEnabled());
            this.setUserDefinedPatterns(dialog.getUserDefinedPatterns());
            this.storeViewDefaults();
            this.updateViewerFilters();
        } else {
            this.storeViewDefaults();
        }
    }

    private static class FilterItem {
        boolean enabled;
        boolean previouslyEnabled;
        OutlineFilterDescriptor descriptor;
        String id;
        private ViewerFilter filterInstance = null;

        public FilterItem(OutlineFilterDescriptor descriptor) {
            this.descriptor = descriptor;
            this.id = descriptor.getId();
            this.previouslyEnabled = false;
            this.enabled = descriptor.isEnabled();
        }

        public ViewerFilter getFilterInstance() {
            if (this.filterInstance == null) {
                this.filterInstance = this.descriptor.createViewerFilter();
            }
            return this.filterInstance;
        }
    }
}

