/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

final class CollectMissingNaturesVisitor
implements IResourceDeltaVisitor {
    private final Set<String> missingNatures = new HashSet<String>();

    CollectMissingNaturesVisitor() {
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getResource().getType() == 8 || delta.getResource().getType() == 4) {
            return delta.getResource().isAccessible();
        }
        if (delta.getResource().getType() == 1 && ".project".equals(delta.getResource().getName()) && (delta.getKind() == 1 || delta.getKind() == 4)) {
            IProject project = delta.getResource().getProject();
            if (!project.isAccessible()) {
                return false;
            }
            String[] stringArray = project.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                if (project.getWorkspace().getNatureDescriptor(natureId) == null) {
                    this.missingNatures.add(natureId);
                }
                ++n2;
            }
        }
        return false;
    }

    public Set<String> getMissingNatures() {
        return this.missingNatures;
    }
}

