/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.ChangesSection;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class ForwardingChangesSection
extends ChangesSection {
    private Composite messageArea;

    public ForwardingChangesSection(Composite parent, AbstractSynchronizePage page, ISynchronizePageConfiguration configuration) {
        super(parent, page, configuration);
    }

    @Override
    protected void initializeChangesViewer() {
        this.calculateDescription();
    }

    protected void calculateDescription() {
        if (this.getContainer().isDisposed()) {
            return;
        }
        if (this.getVisibleChangesCount() == 0L) {
            TeamUIPlugin.getStandardDisplay().asyncExec(() -> {
                if (!this.getContainer().isDisposed()) {
                    this.updatePage(this.getEmptyChangesComposite((Composite)this.getContainer()));
                }
            });
        } else {
            TeamUIPlugin.getStandardDisplay().asyncExec(() -> this.updatePage(null));
        }
    }

    protected void updatePage(Composite message) {
        if (this.getContainer().isDisposed()) {
            return;
        }
        if (this.messageArea != null) {
            this.messageArea.dispose();
            this.messageArea = null;
        }
        this.messageArea = message;
        if (message == null) {
            Control control = this.getChangesViewer().getControl();
            if (!this.getContainer().isDisposed() && !control.isDisposed()) {
                this.getContainer().showPage(control);
            }
        } else {
            this.getContainer().showPage((Control)this.messageArea);
        }
    }

    protected Composite getEmptyChangesComposite(Composite parent) {
        long numChanges;
        int currentMode;
        int candidateMode;
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getListBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        if (!this.isThreeWay()) {
            this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.ChangesSection_noChanges, (Object)Utils.shortenText(100, this.getConfiguration().getParticipant().getName())));
            return composite;
        }
        int allChanges = this.getChangesCount();
        long visibleChanges = this.getVisibleChangesCount();
        if (visibleChanges == 0L && allChanges != 0 && (candidateMode = this.getCandidateMode()) != (currentMode = this.getConfiguration().getMode()) && (numChanges = this.getChangesInMode(candidateMode)) > 0L) {
            String message = numChanges > 1L ? NLS.bind((String)TeamUIMessages.ChangesSection_filterHidesPlural, (Object)Long.toString(numChanges), (Object)Utils.modeToString(candidateMode)) : NLS.bind((String)TeamUIMessages.ChangesSection_filterHidesSingular, (Object)Long.toString(numChanges), (Object)Utils.modeToString(candidateMode));
            message = NLS.bind((String)TeamUIMessages.ChangesSection_filterHides, (Object)Utils.modeToString(this.getConfiguration().getMode()), (Object)message);
            Label warning = new Label(composite, 0);
            warning.setImage(TeamUIPlugin.getPlugin().getImage("ovr/warning_co.gif"));
            Hyperlink link = this.getForms().createHyperlink(composite, NLS.bind((String)TeamUIMessages.ChangesSection_filterChange, (Object)Utils.modeToString(candidateMode)), 64);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ForwardingChangesSection.this.getConfiguration().setMode(candidateMode);
                }
            });
            this.getForms().getHyperlinkGroup().add(link);
            this.createDescriptionLabel(composite, message);
            return composite;
        }
        this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.ChangesSection_noChanges, (Object)Utils.shortenText(100, this.getConfiguration().getParticipant().getName())));
        return composite;
    }

    protected Label createDescriptionLabel(Composite parent, String text) {
        Label description = new Label(parent, 64);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 100;
        description.setLayoutData((Object)data);
        description.setText(text);
        description.setBackground(this.getListBackgroundColor());
        return description;
    }

    protected abstract int getChangesCount();

    protected abstract long getChangesInMode(int var1);

    protected abstract long getVisibleChangesCount();

    protected abstract int getCandidateMode();
}

